/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.HashMap;
import java.util.HashSet;
import lumien.randomthings.block.BlockInventoryRerouter;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityInventoryRerouter
extends TileEntityBase {
    HashMap<EnumFacing, EnumFacing> facingMap = new HashMap();
    static HashSet<TileEntityInventoryRerouter> circleSet = new HashSet();

    public TileEntityInventoryRerouter() {
        for (EnumFacing f : EnumFacing.field_82609_l) {
            this.facingMap.put(f, f);
        }
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        NBTTagList facingList = new NBTTagList();
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing facing = EnumFacing.field_82609_l[i];
            EnumFacing override = this.facingMap.get(facing);
            facingList.func_74742_a((NBTBase)new NBTTagInt(override == null ? -1 : override.func_176745_a()));
        }
        compound.func_74782_a("facingList", (NBTBase)facingList);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        NBTTagList facingList = compound.func_150295_c("facingList", 3);
        for (int i = 0; i < facingList.func_74745_c(); ++i) {
            EnumFacing facing = EnumFacing.field_82609_l[i];
            int overrideIndex = facingList.func_186858_c(i);
            EnumFacing override = overrideIndex == -1 ? null : EnumFacing.field_82609_l[overrideIndex];
            this.facingMap.put(facing, override);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        IBlockState myState;
        if (circleSet.contains((Object)this)) {
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (myState = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((IProperty)BlockInventoryRerouter.FACING) != facing) {
            EnumFacing override = this.facingMap.get(facing);
            if (override == null) {
                return null;
            }
            EnumFacing myFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockInventoryRerouter.FACING);
            TileEntity facingTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(myFacing));
            if (facingTE == null) {
                return null;
            }
            circleSet.add(this);
            Object resultCap = facingTE.getCapability(capability, override);
            circleSet.remove((Object)this);
            return (T)resultCap;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        IBlockState myState;
        if (circleSet.contains((Object)this)) {
            return false;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (myState = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((IProperty)BlockInventoryRerouter.FACING) != facing) {
            EnumFacing override = this.facingMap.get(facing);
            if (override == null) {
                return false;
            }
            EnumFacing myFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockInventoryRerouter.FACING);
            TileEntity facingTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(myFacing));
            if (facingTE == null) {
                return false;
            }
            circleSet.add(this);
            boolean resultBool = facingTE.hasCapability(capability, override);
            circleSet.remove((Object)this);
            return resultBool;
        }
        return super.hasCapability(capability, facing);
    }

    public void rotateFacing(EnumFacing facing) {
        EnumFacing current = this.facingMap.get(facing);
        Object newFacing = current == null ? EnumFacing.field_82609_l[0] : (current == EnumFacing.EAST ? null : EnumFacing.field_82609_l[current.func_176745_a() + 1]);
        this.facingMap.put(facing, (EnumFacing)newFacing);
        this.syncTE();
        this.field_145850_b.func_175685_c(this.field_174879_c, (Block)ModBlocks.inventoryRerouter, false);
    }

    public HashMap<EnumFacing, EnumFacing> getFacingMap() {
        return this.facingMap;
    }
}

