/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.RandomUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityFluidDisplay
extends TileEntityBase {
    FluidStack fluidStack;
    boolean flowing;
    Rotation rotation = Rotation.NONE;

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        NBTTagCompound fluidCompound = new NBTTagCompound();
        if (this.fluidStack != null) {
            this.fluidStack.writeToNBT(fluidCompound);
        }
        compound.func_74782_a("fluidStack", (NBTBase)fluidCompound);
        compound.func_74757_a("flowing", this.flowing);
        compound.func_74768_a("rotation", this.rotation.ordinal());
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        this.fluidStack = compound.func_74764_b("fluidStack") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("fluidStack")) : new FluidStack(FluidRegistry.WATER, 1000);
        this.flowing = compound.func_74767_n("flowing");
        this.rotation = Rotation.values()[compound.func_74762_e("rotation")];
    }

    @Override
    public boolean renderAfterData() {
        return true;
    }

    public void toggleFlowing() {
        this.flowing = !this.flowing;
        this.func_70296_d();
        this.syncTE();
    }

    public boolean flowing() {
        return this.flowing;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public void setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void cycleRotation() {
        this.rotation = RandomUtil.rotateEnum(this.rotation);
        this.func_70296_d();
        this.syncTE();
    }
}

