/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lumien.randomthings.block.BlockEnderBridge;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityEnderBridge
extends TileEntityBase
implements ITickable {
    BRIDGESTATE state = BRIDGESTATE.IDLE;
    boolean redstonePowered = false;
    int scanningCounter = 2;
    public static Set<Class<? extends Entity>> entityWhitelist = new HashSet<Class<? extends Entity>>();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.state == BRIDGESTATE.SCANNING) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockEnderBridge.FACING);
            BlockPos nextPos = new BlockPos((Vec3i)this.field_174879_c.func_177967_a(facing, this.scanningCounter));
            if (this.field_145850_b.func_175667_e(nextPos)) {
                IBlockState nextState = this.field_145850_b.func_180495_p(nextPos);
                if (nextState.func_177230_c() == ModBlocks.enderAnchor) {
                    List entityList = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)(this.field_174879_c.func_177956_o() - 2), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 2)), null);
                    if (!entityList.isEmpty()) {
                        BlockPos target = nextPos.func_177984_a();
                        for (Entity e : entityList) {
                            if (!entityWhitelist.stream().anyMatch(c -> c.isAssignableFrom(e.getClass()))) continue;
                            WorldUtil.setEntityPosition(e, (double)target.func_177958_n() + 0.5, target.func_177956_o(), (double)target.func_177952_p() + 0.5);
                        }
                    }
                    this.state = BRIDGESTATE.WAITING;
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockEnderBridge.ACTIVE, (Comparable)Boolean.valueOf(false)));
                } else if (!nextState.func_177230_c().isAir(nextState, (IBlockAccess)this.field_145850_b, nextPos)) {
                    this.state = BRIDGESTATE.WAITING;
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockEnderBridge.ACTIVE, (Comparable)Boolean.valueOf(false)));
                }
            }
            ++this.scanningCounter;
        }
    }

    @Override
    public void neighborChanged(IBlockState blockState, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        if (!worldIn.field_72995_K) {
            boolean powered;
            boolean bl = powered = worldIn.func_175687_A(pos) != 0;
            if (powered != this.redstonePowered) {
                if (this.state == BRIDGESTATE.IDLE && powered) {
                    this.scanningCounter = 2;
                    this.state = BRIDGESTATE.SCANNING;
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockEnderBridge.ACTIVE, (Comparable)Boolean.valueOf(true)));
                } else if (this.state == BRIDGESTATE.SCANNING && !powered) {
                    this.state = BRIDGESTATE.IDLE;
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockEnderBridge.ACTIVE, (Comparable)Boolean.valueOf(false)));
                } else if (this.state == BRIDGESTATE.WAITING && !powered) {
                    this.state = BRIDGESTATE.IDLE;
                }
                this.redstonePowered = powered;
            }
        }
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("state", this.state.ordinal());
        compound.func_74757_a("redstonePowered", this.redstonePowered);
        compound.func_74768_a("scanningCounter", this.scanningCounter);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        this.state = BRIDGESTATE.values()[compound.func_74762_e("state")];
        this.redstonePowered = compound.func_74767_n("redstonePowered");
        this.scanningCounter = compound.func_74762_e("scanningCounter");
    }

    static {
        entityWhitelist.add(EntityPlayerMP.class);
        entityWhitelist.add(EntityItem.class);
        entityWhitelist.add(EntityMinecart.class);
    }

    static enum BRIDGESTATE {
        IDLE,
        SCANNING,
        WAITING;

    }
}

