/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.awt.Color;
import java.util.List;
import lumien.randomthings.handler.spectrecoils.SpectreCoilHandler;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.lib.ILuminousItem;
import lumien.randomthings.lib.IRTItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemSpectreCharger
extends ItemBase
implements IRTItemColor,
ILuminousItem,
IBauble {
    public ItemSpectreCharger() {
        super("spectreCharger");
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        String display;
        switch (TIER.values()[stack.func_77952_i()]) {
            case NORMAL: {
                display = I18n.func_135052_a((String)"item.spectreCharger.charge", (Object[])new Object[]{"1024"});
                break;
            }
            case REDSTONE: {
                display = I18n.func_135052_a((String)"item.spectreCharger.charge", (Object[])new Object[]{"4096"});
                break;
            }
            case ENDER: {
                display = I18n.func_135052_a((String)"item.spectreCharger.charge", (Object[])new Object[]{"20480"});
                break;
            }
            case GENESIS: {
                display = I18n.func_135052_a((String)"item.spectreCharger.charge", (Object[])new Object[]{"Infinite"});
                break;
            }
            default: {
                display = I18n.func_135052_a((String)"item.spectreCharger.charge", (Object[])new Object[]{"???"});
            }
        }
        tooltip.add(display);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + TIER.values()[stack.func_77952_i()].name;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        NBTTagCompound options;
        ItemStack me = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)me);
        }
        boolean enabled = (options = me.func_190925_c("options")).func_74767_n("enabled");
        options.func_74757_a("enabled", !enabled);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)me);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound options;
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayerMP && (options = stack.func_190925_c("options")).func_74767_n("enabled")) {
            EntityPlayerMP player = (EntityPlayerMP)entityIn;
            IEnergyStorage storage = SpectreCoilHandler.get(worldIn).getStorageCoil(player.func_146103_bH().getId());
            int rate = 1;
            TIER tier = TIER.values()[stack.func_77952_i()];
            if (tier == TIER.NORMAL) {
                rate = 1024;
            } else if (tier == TIER.REDSTONE) {
                rate = 4096;
            } else if (tier == TIER.ENDER) {
                rate = 20480;
            }
            for (int slot = 0; slot < player.field_71071_by.func_70302_i_() && (storage.getEnergyStored() != 0 || tier == TIER.GENESIS); ++slot) {
                int attemptExtractEnergy;
                int energyExtracted;
                int remainder;
                IEnergyStorage itemStorage;
                ItemStack targetStack = player.field_71071_by.func_70301_a(slot);
                if (!targetStack.hasCapability(CapabilityEnergy.ENERGY, null) || (itemStorage = (IEnergyStorage)targetStack.getCapability(CapabilityEnergy.ENERGY, null)) == null) continue;
                int missingEnergy = itemStorage.getMaxEnergyStored() - itemStorage.getEnergyStored();
                if (tier == TIER.GENESIS) {
                    itemStorage.receiveEnergy(missingEnergy, false);
                    continue;
                }
                if (missingEnergy <= 0 || (remainder = (energyExtracted = storage.extractEnergy(attemptExtractEnergy = Math.min(rate, missingEnergy), false)) - itemStorage.receiveEnergy(energyExtracted, false)) <= 0) continue;
                storage.receiveEnergy(remainder, false);
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w()) {
            for (TIER t : TIER.values()) {
                items.add((Object)new ItemStack((Item)this, 1, t.ordinal()));
            }
        }
    }

    @Override
    public boolean shouldGlow(ItemStack stack, int tintIndex) {
        return tintIndex == 1;
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        return tintIndex == 1 ? TIER.values()[stack.func_77952_i()].color : -1;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BELT;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        this.func_77663_a(itemstack, player.field_70170_p, (Entity)player, 0, false);
    }

    public static enum TIER {
        NORMAL("normal", Color.CYAN.getRGB()),
        REDSTONE("redstone", Color.RED.getRGB()),
        ENDER("ender", new Color(200, 0, 210).getRGB()),
        GENESIS("genesis", Color.ORANGE.getRGB());

        int color;
        String name;

        private TIER(String name, int color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }
    }
}

