/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;

public class ItemEnderBucket
extends ItemBase {
    public ItemEnderBucket() {
        super("enderBucket");
        this.func_77625_d(1);
    }

    public int getItemStackLimit(ItemStack stack) {
        IFluidHandlerItem item = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (item == null) {
            return 16;
        }
        FluidStack fluidStack = item.drain(1000, false);
        if (fluidStack != null) {
            return 1;
        }
        return 16;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStackSimple(stack, 1000);
    }

    @Nullable
    public FluidStack getFluid(@Nonnull ItemStack container) {
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p());
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        IFluidHandlerItem item = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        FluidStack fluidStack = item.drain(1000, false);
        if (fluidStack == null) {
            return super.func_77653_i(stack);
        }
        return I18n.func_74837_a((String)(this.func_77657_g(stack) + ".filled.name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        IBlockState hitState;
        Block hitBlock;
        FluidStack drain;
        ItemStack itemstack = player.func_184586_b(hand);
        IFluidHandlerItem item = (IFluidHandlerItem)itemstack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        boolean isFull = false;
        if (item != null && (drain = item.drain(1000, false)) != null && drain.amount == 1000) {
            isFull = true;
        }
        if (isFull) {
            FluidActionResult result;
            BlockPos targetPos;
            FluidStack fluidStack = item.drain(1000, false);
            RayTraceResult mop = this.func_77621_a(world, player, false);
            if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
            }
            BlockPos clickPos = mop.func_178782_a();
            if (world.func_175660_a(player, clickPos) && player.func_175151_a(targetPos = clickPos.func_177972_a(mop.field_178784_b), mop.field_178784_b, itemstack) && (result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)targetPos, (ItemStack)itemstack, (FluidStack)fluidStack)).isSuccess()) {
                player.func_71029_a(StatList.func_188057_b((Item)this));
                ItemStack drained = result.getResult();
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)drained);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
        }
        RayTraceResult mop = WorldUtil.rayTraceAll(world, player, true);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && ((hitBlock = (hitState = world.func_180495_p(mop.func_178782_a())).func_177230_c()) instanceof IFluidBlock || hitBlock instanceof BlockLiquid)) {
            ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
            HashSet<BlockPos> alreadyChecked = new HashSet<BlockPos>();
            stack.add(mop.func_178782_a());
            while (!stack.isEmpty()) {
                IBlockState nextState;
                Block nextBlock;
                BlockPos next = (BlockPos)stack.remove(0);
                alreadyChecked.add(next);
                if (alreadyChecked.size() > 2000) break;
                if (!world.func_175667_e(next) || !((nextBlock = (nextState = world.func_180495_p(next)).func_177230_c()) instanceof IFluidBlock) && !(nextBlock instanceof BlockLiquid)) continue;
                FluidActionResult pickupResult = FluidUtil.tryPickUpFluid((ItemStack)itemstack, (EntityPlayer)player, (World)world, (BlockPos)next, (EnumFacing)EnumFacing.UP);
                if (pickupResult.success) {
                    if (itemstack.func_190916_E() > 1) {
                        ItemStack returnStack = itemstack.func_77946_l();
                        returnStack.func_190918_g(1);
                        ItemStack add = pickupResult.result;
                        pickupResult.result.func_190920_e(1);
                        if (!player.field_71071_by.func_70441_a(add)) {
                            player.func_71019_a(add, false);
                        }
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)returnStack);
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)pickupResult.result);
                }
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos addingPos = next.func_177972_a(facing);
                    if (alreadyChecked.contains(addingPos)) continue;
                    stack.add(addingPos);
                    alreadyChecked.add(addingPos);
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }
}

