/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.container;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lumien.randomthings.RandomThings;
import lumien.randomthings.lib.ContainerSynced;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import org.apache.logging.log4j.Level;

public class SyncHandler {
    static Map<Class, ArrayList<Field>> fieldMap = new HashMap<Class, ArrayList<Field>>();

    public static void postInit(FMLPostInitializationEvent event) {
        Set annotationSet = RandomThings.instance.getASMData().getAll(ContainerSynced.class.getName());
        for (ASMDataTable.ASMData data : annotationSet) {
            try {
                ArrayList<Field> classFieldList;
                Class<?> clazz = Class.forName(data.getClassName());
                Field f = clazz.getDeclaredField(data.getObjectName());
                f.setAccessible(true);
                if (fieldMap.containsKey(clazz)) {
                    classFieldList = fieldMap.get(clazz);
                } else {
                    classFieldList = new ArrayList();
                    fieldMap.put(clazz, classFieldList);
                }
                classFieldList.add(f);
                Collections.sort(classFieldList, new Comparator<Field>(){

                    @Override
                    public int compare(Field field1, Field field2) {
                        return field1.getName().compareTo(field2.getName());
                    }
                });
            }
            catch (Exception e) {
                RandomThings.instance.logger.log(Level.ERROR, "Error stitching extra textures");
                e.printStackTrace();
            }
        }
    }
}

