/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import com.mojang.authlib.GameProfile;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.tileentity.TileEntitySpectreLens;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpectreLens
extends BlockContainerBase {
    AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    protected BlockSpectreLens() {
        super("spectreLens", Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canPlaceOn(worldIn, pos.func_177977_b());
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        super.func_189540_a(state, worldIn, pos, neighborBlock, changedPos);
        this.checkForDrop(worldIn, pos, state);
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150461_bJ;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceOn(worldIn, pos.func_177977_b())) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof TileEntitySpectreLens) {
                ((TileEntitySpectreLens)te).breakBlock(worldIn, pos, state);
            }
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EntityPlayer player;
        GameProfile profile;
        if (!worldIn.field_72995_K && placer instanceof EntityPlayer && (profile = (player = (EntityPlayer)placer).func_146103_bH()) != null) {
            TileEntitySpectreLens lens = (TileEntitySpectreLens)worldIn.func_175625_s(pos);
            lens.setOwner(profile.getId());
        }
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySpectreLens();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

