/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.trees;

import java.util.Random;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.dave.bonsaitrees.BonsaiTrees;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.trees.TreeShape;
import org.dave.bonsaitrees.trees.TreeShapeRegistry;
import org.dave.bonsaitrees.utility.Logz;

public class ShapeGenerator {
    public static final int NUM_SHAPES = 3;

    private static TreeShape generateShape(World world, BlockPos pos, IBonsaiTreeType type, Random rand) {
        TreeShape result = new TreeShape(type.getName());
        IBonsaiIntegration integrator = BonsaiTrees.instance.typeRegistry.getIntegrationForType(type);
        world.func_175656_a(pos.func_177977_b(), Blocks.field_150349_c.func_176223_P());
        integrator.generateTree(type, world, pos, rand);
        for (int heightDiff = 0; world.func_175623_d(pos) && heightDiff < 8; ++heightDiff) {
            pos = pos.func_177984_a();
        }
        result.setBlocksByFloodFill(world, pos);
        integrator.modifyTreeShape(type, result.getBlocks());
        return result;
    }

    public static void generateMissingShapes(ICommandSender sender, World world, BlockPos pos) {
        Random rand = new Random();
        for (IBonsaiTreeType type : BonsaiTrees.instance.typeRegistry.getAllTypes()) {
            int shapes = TreeShapeRegistry.getShapeCountForType(type);
            if (shapes > 0) continue;
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.generateMissingShapes.info", new Object[]{type.getName()}));
            Logz.info("Generating shapes for tree: %s", type.getName());
            ShapeGenerator.clearArea(world, pos, 32);
            for (int i = 0; i < 3; ++i) {
                TreeShape treeShape = ShapeGenerator.generateShape(world, pos, type, rand);
                ShapeGenerator.clearArea(world, pos, 32);
                if (treeShape == null) continue;
                if (treeShape.getBlocks().size() == 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.generateMissingShapes.exception.no_shape", new Object[0]));
                    Logz.warn("Can not determine shape", new Object[0]);
                    continue;
                }
                String filename = treeShape.saveToFile();
                if (filename == null) continue;
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.generateMissingShapes.created_shape_file", new Object[]{filename}));
                Logz.info("Created shape file: %s", filename);
            }
        }
    }

    private static void clearArea(World world, BlockPos pos, int areaSize) {
        for (int deltaX = 0; deltaX < areaSize; ++deltaX) {
            for (int deltaY = 0; deltaY < areaSize; ++deltaY) {
                for (int deltaZ = 0; deltaZ < areaSize; ++deltaZ) {
                    int x = pos.func_177958_n() - areaSize / 2;
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p() - areaSize / 2;
                    world.func_175698_g(new BlockPos(x += deltaX, y += deltaY, z += deltaZ));
                }
            }
        }
    }
}

