/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.command;

import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.dave.bonsaitrees.BonsaiTrees;
import org.dave.bonsaitrees.api.IBonsaiSoil;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.base.CommandBaseExt;

public class CommandCheckCompatibility
extends CommandBaseExt {
    public String func_71517_b() {
        return "checkCompatibility";
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.checkCompatibility.exception.specify_tree_or_soil", new Object[0]));
            return;
        }
        String searchTerm = args[0];
        IBonsaiTreeType treeType = BonsaiTrees.instance.typeRegistry.getTypeByName(searchTerm);
        if (treeType != null) {
            LinkedList<IBonsaiSoil> supportedSoils = new LinkedList<IBonsaiSoil>(BonsaiTrees.instance.soilCompatibility.getValidSoilsForTree(treeType));
            supportedSoils.sort(Comparator.comparing(IBonsaiSoil::getName));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.checkCompatibility.result_title_soils", new Object[]{supportedSoils.size()}));
            for (IBonsaiSoil soil : supportedSoils) {
                sender.func_145747_a((ITextComponent)new TextComponentString(" - " + soil.getName()));
            }
            return;
        }
        IBonsaiSoil soil = BonsaiTrees.instance.soilRegistry.getTypeByName(searchTerm);
        if (soil != null) {
            LinkedList<IBonsaiTreeType> supportedTrees = new LinkedList<IBonsaiTreeType>(BonsaiTrees.instance.soilCompatibility.getValidTreesForSoil(soil));
            supportedTrees.sort(Comparator.comparing(IBonsaiTreeType::getName));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.checkCompatibility.result_title_trees", new Object[]{supportedTrees.size()}));
            for (IBonsaiTreeType tree : supportedTrees) {
                sender.func_145747_a((ITextComponent)new TextComponentString(" - " + tree.getName()));
            }
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.checkCompatibility.exception.no_valid_soil_or_tree_found", new Object[0]));
    }
}

