/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.block;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.DyeUtils;
import org.dave.bonsaitrees.BonsaiTrees;
import org.dave.bonsaitrees.api.IBonsaiCuttingTool;
import org.dave.bonsaitrees.api.IBonsaiSoil;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.base.BaseBlockWithTile;
import org.dave.bonsaitrees.base.IMetaBlockName;
import org.dave.bonsaitrees.compat.TheOneProbe.ITopInfoProvider;
import org.dave.bonsaitrees.init.Blockss;
import org.dave.bonsaitrees.misc.ConfigurationHandler;
import org.dave.bonsaitrees.render.TESRBonsaiPot;
import org.dave.bonsaitrees.tile.HoppingItemStackBufferHandler;
import org.dave.bonsaitrees.tile.TileBonsaiPot;
import org.dave.bonsaitrees.utility.Logz;

public class BlockBonsaiPot
extends BaseBlockWithTile<TileBonsaiPot>
implements IGrowable,
IMetaBlockName,
ITopInfoProvider {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB((double)0.065f, (double)0.005f, (double)0.065f, (double)0.935f, (double)0.185f, (double)0.935f);
    public static final PropertyBool IS_HOPPING = PropertyBool.func_177716_a((String)"hopping");

    public BlockBonsaiPot(Material material) {
        super(material);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IS_HOPPING, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!stack.func_77942_o()) {
            return;
        }
        if (!(world.func_175625_s(pos) instanceof TileBonsaiPot)) {
            return;
        }
        TileBonsaiPot bonsaiPot = (TileBonsaiPot)world.func_175625_s(pos);
        NBTTagCompound potStack = stack.func_77978_p();
        if (potStack.func_74764_b("color")) {
            bonsaiPot.setColor(EnumDyeColor.func_176764_b((int)potStack.func_74762_e("color")));
            bonsaiPot.func_70296_d();
            world.func_184138_a(pos, state, state, 11);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
        if (world.field_72995_K) {
            return;
        }
        if (player.func_184812_l_()) {
            return;
        }
        if (!(world.func_175625_s(pos) instanceof TileBonsaiPot)) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileBonsaiPot pot = (TileBonsaiPot)world.func_175625_s(pos);
        if (pot.hasSapling()) {
            if (pot.isHarvestable()) {
                drops.addAll(pot.getRandomizedDrops());
            }
            drops.add(pot.getSapling());
        }
        if (pot.hasSoil()) {
            drops.add(pot.getSoilStack());
        }
        ItemStack potStack = new ItemStack((Block)Blockss.bonsaiPot, 1, this.func_176201_c(state));
        if (pot.getColor() != null) {
            NBTTagCompound potNbt = new NBTTagCompound();
            potNbt.func_74768_a("color", pot.getColor().func_176765_a());
            potStack.func_77982_d(potNbt);
        }
        drops.add(potStack);
        for (ItemStack drop : drops) {
            BlockBonsaiPot.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack result = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
        if (!(world.func_175625_s(pos) instanceof TileBonsaiPot)) {
            return result;
        }
        TileBonsaiPot pot = (TileBonsaiPot)world.func_175625_s(pos);
        if (pot.getColor() != null) {
            NBTTagCompound potNbt = new NBTTagCompound();
            potNbt.func_74768_a("color", pot.getColor().func_176765_a());
            result.func_77982_d(potNbt);
        }
        return result;
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return (Boolean)this.func_176203_a(stack.func_77952_i()).func_177229_b((IProperty)IS_HOPPING) != false ? "hopping" : "";
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IS_HOPPING});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_HOPPING) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IS_HOPPING, (Comparable)Boolean.valueOf(meta == 1));
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canGrow(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        return BonsaiTrees.instance.typeRegistry.getTypeByStack(stack) != null;
    }

    private boolean canCutBonsaiTree(ItemStack stack, EntityPlayer player) {
        if (stack.func_77973_b().getHarvestLevel(stack, "axe", player, Blocks.field_150344_f.func_176223_P()) != -1) {
            return true;
        }
        if (stack.func_77973_b() instanceof IBonsaiCuttingTool) {
            return true;
        }
        String regName = stack.func_77973_b().getRegistryName().toString();
        return ConfigurationHandler.IntegrationSettings.additionalCuttingTools.contains(regName);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean playerHasSapling;
        boolean playerHasShovel;
        if (player.func_70093_af()) {
            return false;
        }
        if (!(world.func_175625_s(pos) instanceof TileBonsaiPot)) {
            return false;
        }
        ItemStack playerStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (playerStack.func_190926_b()) {
            playerStack = player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (playerStack.func_190926_b()) {
            return false;
        }
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        TileBonsaiPot pot = (TileBonsaiPot)world.func_175625_s(pos);
        float epsilon = 0.01f;
        if (Math.abs(hitY - 0.19f) < epsilon && (double)hitX >= 0.13 && (double)hitX <= 0.87 && (double)hitZ >= 0.13 && (double)hitZ <= 0.87 && playerStack.func_77973_b() == Items.field_151100_aR && playerStack.func_77960_j() == 15) {
            return false;
        }
        if (DyeUtils.isDye((ItemStack)playerStack)) {
            EnumDyeColor color = DyeUtils.colorFromStack((ItemStack)playerStack).orElse(EnumDyeColor.GRAY);
            if (color == pot.getColor()) {
                return true;
            }
            if (!(world.field_72995_K || player.func_184812_l_() || ConfigurationHandler.GeneralSettings.noDyeCost)) {
                playerStack.func_77979_a(1);
            }
            pot.setColor(color);
            return true;
        }
        boolean playerHasSoil = BonsaiTrees.instance.soilRegistry.isValidSoil(playerStack);
        if (playerHasSoil) {
            if (pot.hasSoil()) {
                return false;
            }
            if (pot.hasSapling()) {
                return false;
            }
            if (player.func_184812_l_()) {
                ItemStack soilStack = playerStack.func_77946_l();
                soilStack.func_190920_e(1);
                pot.setSoil(soilStack);
            } else {
                pot.setSoil(playerStack.func_77979_a(1));
            }
            return true;
        }
        boolean playerHasAxe = this.canCutBonsaiTree(playerStack, player);
        if (playerHasAxe) {
            if (!pot.hasSapling()) {
                return false;
            }
            if (pot.isHarvestable() && playerStack.func_77952_i() + 1 < playerStack.func_77958_k()) {
                pot.dropLoot();
                pot.setSapling(pot.getSapling());
                playerStack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
            if (pot.getProgress() >= 20.0 && pot.getProgressPercent() <= 0.75) {
                pot.dropSapling();
                return true;
            }
            return true;
        }
        boolean bl = playerHasShovel = playerStack.func_77973_b().getHarvestLevel(playerStack, "shovel", player, Blocks.field_150346_d.func_176223_P()) != -1;
        if (playerHasShovel) {
            if (pot.hasSapling()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("hint.bonsaitrees.can_not_remove_soil_with_sapling", new Object[0]), true);
                return false;
            }
            if (!pot.hasSoil()) {
                return false;
            }
            pot.dropSoil();
            return true;
        }
        IBonsaiTreeType treeType = BonsaiTrees.instance.typeRegistry.getTypeByStack(playerStack);
        boolean bl2 = playerHasSapling = treeType != null;
        if (playerHasSapling) {
            if (!pot.hasSoil()) {
                int randomSlot = world.field_73012_v.nextInt(BonsaiTrees.instance.soilRegistry.getAllSoils().size());
                Optional<IBonsaiSoil> optionalSoil = BonsaiTrees.instance.soilRegistry.getAllSoils().stream().skip(randomSlot).findFirst();
                if (optionalSoil.isPresent()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("hint.bonsaitrees.pot_has_no_soil", new Object[]{optionalSoil.get().getSoilStack().func_82833_r()}), true);
                } else {
                    Logz.warn("There is no soil available. Please check the config and logs for errors!", new Object[0]);
                }
                return false;
            }
            if (pot.hasSapling()) {
                return false;
            }
            if (!BonsaiTrees.instance.soilCompatibility.canTreeGrowOnSoil(treeType, pot.getBonsaiSoil())) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("hint.bonsaitrees.incompatible_soil", new Object[0]), true);
                return false;
            }
            if (player.func_184812_l_()) {
                ItemStack soilStack = playerStack.func_77946_l();
                soilStack.func_190920_e(1);
                pot.setSapling(soilStack);
            } else {
                pot.setSapling(playerStack.func_77979_a(1));
            }
            return true;
        }
        return true;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBonsaiPot();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "hopping=false"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "hopping=true"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileBonsaiPot.class, (TileEntitySpecialRenderer)new TESRBonsaiPot());
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (!(world.func_175625_s(pos) instanceof TileBonsaiPot)) {
            return false;
        }
        TileBonsaiPot pot = (TileBonsaiPot)world.func_175625_s(pos);
        return pot.isGrowing();
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        if (!(world.func_175625_s(pos) instanceof TileBonsaiPot)) {
            return false;
        }
        TileBonsaiPot pot = (TileBonsaiPot)world.func_175625_s(pos);
        if (!pot.isGrowing()) {
            return false;
        }
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        if (!(world.func_175625_s(pos) instanceof TileBonsaiPot)) {
            return;
        }
        TileBonsaiPot pot = (TileBonsaiPot)world.func_175625_s(pos);
        pot.boostProgress();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        HoppingItemStackBufferHandler hoppingItemBuffer;
        if (!(world.func_175625_s(data.getPos()) instanceof TileBonsaiPot)) {
            return;
        }
        TileBonsaiPot teBonsai = (TileBonsaiPot)world.func_175625_s(data.getPos());
        if (teBonsai.hasSapling()) {
            probeInfo.horizontal().item(teBonsai.getSapling()).itemLabel(teBonsai.getSapling());
        }
        if (teBonsai.hasSoil()) {
            probeInfo.horizontal().item(teBonsai.getSoilStack()).itemLabel(teBonsai.getSoilStack());
        }
        if (teBonsai.hasSapling()) {
            probeInfo.progress((int)(teBonsai.getProgressPercent() * 100.0), 100, probeInfo.defaultProgressStyle().suffix("%").filledColor(-12277180).alternateFilledColor(-12277180).backgroundColor(-8165037));
        }
        if (mode == ProbeMode.EXTENDED && (hoppingItemBuffer = teBonsai.getHoppingItemBuffer()) != null && !hoppingItemBuffer.isEmpty()) {
            IProbeInfo line = probeInfo.horizontal();
            for (int srcSlot = 0; srcSlot < hoppingItemBuffer.getSlots(); ++srcSlot) {
                ItemStack stack = hoppingItemBuffer.getStackInSlot(srcSlot);
                if (stack.func_190926_b()) continue;
                line.item(stack);
            }
        }
    }
}

