/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.worldgen;

import java.util.Random;
import lykrast.prodigytech.common.init.ModBlocks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenZorraTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = ModBlocks.zorraLog.func_176223_P();
    private static final IBlockState LEAVES = ModBlocks.zorraLeaves.func_176223_P();

    public WorldGenZorraTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int height = rand.nextInt(3) + 5;
        boolean canGenerate = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + height; ++y) {
                int radius = 1;
                if (y == position.func_177956_o()) {
                    radius = 0;
                }
                if (y >= position.func_177956_o() + 1 + height - 2) {
                    radius = 2;
                }
                BlockPos.MutableBlockPos mutpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - radius; l <= position.func_177958_n() + radius && canGenerate; ++l) {
                    for (int i1 = position.func_177952_p() - radius; i1 <= position.func_177952_p() + radius && canGenerate; ++i1) {
                        if (y >= 0 && y < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutpos.func_181079_c(l, y, i1))) continue;
                            canGenerate = false;
                            continue;
                        }
                        canGenerate = false;
                    }
                }
            }
            if (!canGenerate) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - height - 1) {
                int y;
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                for (y = position.func_177956_o() - 4 + height; y <= position.func_177956_o() + height; ++y) {
                    int deltaY = y - (position.func_177956_o() + height);
                    int radius = deltaY == -4 ? 1 : 1 - deltaY / 2;
                    for (int x = position.func_177958_n() - radius; x <= position.func_177958_n() + radius; ++x) {
                        int deltaX = x - position.func_177958_n();
                        for (int z = position.func_177952_p() - radius; z <= position.func_177952_p() + radius; ++z) {
                            BlockPos blockpos;
                            IBlockState state2;
                            int deltaZ = z - position.func_177952_p();
                            if (Math.abs(deltaX) == radius && Math.abs(deltaZ) == radius && (rand.nextInt(2) == 0 || deltaY == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                            this.func_175903_a(worldIn, blockpos, LEAVES);
                        }
                    }
                }
                for (y = 0; y < height; ++y) {
                    BlockPos upN = position.func_177981_b(y);
                    IBlockState state2 = worldIn.func_180495_p(upN);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(y), LOG);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

