/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.util;

import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.IHotAir;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TemperatureHelper {
    private TemperatureHelper() {
    }

    public static void hotAirDamage(Entity entity, int temperature) {
        float damage;
        if (!entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity)) && (damage = TemperatureHelper.getDamageFromTemperature(temperature)) >= 1.0f) {
            entity.func_70097_a(DamageSource.field_190095_e, damage);
        }
    }

    public static void hotAirDamage(Entity entity, IHotAir hotAir) {
        TemperatureHelper.hotAirDamage(entity, hotAir.getOutAirTemperature());
    }

    public static float getDamageFromTemperature(int temperature) {
        if (temperature < 100) {
            return 0.0f;
        }
        return (float)temperature / 50.0f;
    }

    public static int getBlockTemp(World world, BlockPos pos) {
        IHotAir capability;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && (capability = (IHotAir)tile.getCapability(CapabilityHotAir.HOT_AIR, EnumFacing.UP)) != null) {
            return capability.getOutAirTemperature();
        }
        return 30;
    }
}

