/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeUtil {
    public static final List<String> MOD_PREFERENCE = new ArrayList<String>();
    public static final List<String> ORE_BLACKLIST = new ArrayList<String>();
    private static final Map<String, ItemStack> PREFERRED_STACKS;

    private RecipeUtil() {
    }

    public static Pair<Item, Integer> stackToPair(ItemStack stack) {
        return new ImmutablePair((Object)stack.func_77973_b(), (Object)stack.func_77960_j());
    }

    public static Pair<Item, Integer> stackToWildcardPair(ItemStack stack) {
        return new ImmutablePair((Object)stack.func_77973_b(), (Object)Short.MAX_VALUE);
    }

    public static ItemStack pairToStack(Pair<Item, Integer> pair) {
        return new ItemStack((Item)pair.getLeft(), 1, ((Integer)pair.getRight()).intValue());
    }

    public static boolean oreExists(String name) {
        return OreDictionary.doesOreNameExist((String)name) && !OreDictionary.getOres((String)name, (boolean)false).isEmpty();
    }

    public static boolean itemExists(String name) {
        return RecipeUtil.itemExists(new ResourceLocation(name));
    }

    public static boolean itemExists(ResourceLocation location) {
        return ForgeRegistries.ITEMS.containsKey(location);
    }

    public static Item getExteriorItem(String name) {
        return RecipeUtil.getExteriorItem(new ResourceLocation(name));
    }

    public static Item getExteriorItem(ResourceLocation location) {
        return (Item)ForgeRegistries.ITEMS.getValue(location);
    }

    public static boolean isOreBlacklisted(String reducedName) {
        return ORE_BLACKLIST.contains(reducedName);
    }

    public static ItemStack getPreferredOreStack(String ore) {
        ItemStack stack;
        if (!PREFERRED_STACKS.containsKey(ore)) {
            stack = RecipeUtil.oreExists(ore) ? RecipeUtil.getPreferredStack((Collection<ItemStack>)OreDictionary.getOres((String)ore)) : ItemStack.field_190927_a;
            PREFERRED_STACKS.put(ore, stack);
        } else {
            stack = PREFERRED_STACKS.get(ore);
        }
        return stack == null ? ItemStack.field_190927_a : stack.func_77946_l();
    }

    public static ItemStack getPreferredStack(Collection<ItemStack> candidates) {
        ItemStack preferred = ItemStack.field_190927_a;
        int rank = -1;
        for (ItemStack stack : candidates) {
            int curRank;
            if (stack.func_190926_b()) continue;
            if (rank == 0) break;
            ResourceLocation resource = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
            if (resource == null) continue;
            String modid = resource.func_110624_b();
            int n = curRank = modid == null || modid.isEmpty() ? -1 : MOD_PREFERENCE.indexOf(modid);
            if (!preferred.func_190926_b() && (curRank < 0 || rank >= 0 && curRank >= rank)) continue;
            preferred = stack;
            rank = curRank;
        }
        return preferred.func_77946_l();
    }

    static {
        MOD_PREFERENCE.add("minecraft");
        MOD_PREFERENCE.add("basemetals");
        MOD_PREFERENCE.add("baseminerals");
        MOD_PREFERENCE.add("modernmetals");
        MOD_PREFERENCE.add("nethermetals");
        MOD_PREFERENCE.add("endmetals");
        MOD_PREFERENCE.add("thermalfoundation");
        MOD_PREFERENCE.add("immersiveengineering");
        MOD_PREFERENCE.add("techreborn");
        MOD_PREFERENCE.add("ic2");
        MOD_PREFERENCE.add("mekanism");
        MOD_PREFERENCE.add("magneticraft");
        MOD_PREFERENCE.add("prodigytech");
        ORE_BLACKLIST.add("Coal");
        ORE_BLACKLIST.add("Lapis");
        ORE_BLACKLIST.add("Redstone");
        ORE_BLACKLIST.add("Quartz");
        ORE_BLACKLIST.add("NetherQuartz");
        ORE_BLACKLIST.add("Prismarine");
        ORE_BLACKLIST.add("Glowstone");
        ORE_BLACKLIST.add("Ferramic");
        ORE_BLACKLIST.add("Energion");
        ORE_BLACKLIST.add("Salt");
        PREFERRED_STACKS = new HashMap<String, ItemStack>();
    }
}

