/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.util;

import java.util.Arrays;
import lykrast.prodigytech.common.util.IProdigyInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ProdigyInventoryHandler
implements IItemHandlerModifiable {
    private IProdigyInventory inventory;
    private int slots;
    private int offset;
    private boolean[] insert;
    private boolean[] extract;

    public ProdigyInventoryHandler(IProdigyInventory inventory, int slots) {
        this(inventory, slots, 0, true, true);
    }

    public ProdigyInventoryHandler(IProdigyInventory inventory, int slots, int offset, boolean insert, boolean extract) {
        this(inventory, slots, offset, new boolean[slots], new boolean[slots]);
        Arrays.fill(this.insert, insert);
        Arrays.fill(this.extract, extract);
    }

    public ProdigyInventoryHandler(IProdigyInventory inventory, int slots, int offset, boolean[] insert, boolean[] extract) {
        this.inventory = inventory;
        this.slots = slots;
        this.offset = offset;
        this.insert = insert;
        this.extract = extract;
    }

    public int getSlots() {
        return this.slots;
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.inventory.getInventory().get(slot + this.offset);
    }

    public boolean canInsert(int slot) {
        return this.insert[slot];
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b() || !this.canInsert(slot)) {
            return stack;
        }
        if (!this.inventory.func_94041_b(slot + this.offset, stack = stack.func_77946_l())) {
            return stack;
        }
        int realSlot = slot + this.offset;
        ItemStack current = (ItemStack)this.inventory.getInventory().get(realSlot);
        if (current.func_190926_b()) {
            int accepted = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
            if (accepted < stack.func_190916_E()) {
                if (!simulate) {
                    this.inventory.getInventory().set(realSlot, (Object)stack.func_77979_a(accepted));
                    this.inventory.updateGraphics(realSlot);
                    return stack;
                }
                stack.func_190918_g(accepted);
                return stack;
            }
            if (!simulate) {
                this.inventory.getInventory().set(realSlot, (Object)stack);
                this.inventory.updateGraphics(realSlot);
            }
            return ItemStack.field_190927_a;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)current)) {
            return stack;
        }
        int accepted = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - current.func_190916_E();
        if (accepted < stack.func_190916_E()) {
            if (!simulate) {
                ItemStack newStack = stack.func_77979_a(accepted);
                newStack.func_190917_f(current.func_190916_E());
                this.inventory.getInventory().set(realSlot, (Object)newStack);
                this.inventory.updateGraphics(realSlot);
                return stack;
            }
            stack.func_190918_g(accepted);
            return stack;
        }
        if (!simulate) {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190917_f(current.func_190916_E());
            this.inventory.getInventory().set(realSlot, (Object)newStack);
            this.inventory.updateGraphics(realSlot);
        }
        return ItemStack.field_190927_a;
    }

    public boolean canExtract(int slot) {
        return this.extract[slot];
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || !this.canExtract(slot)) {
            return ItemStack.field_190927_a;
        }
        int realSlot = slot + this.offset;
        ItemStack stack = (ItemStack)this.inventory.getInventory().get(realSlot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int extracted = Math.min(stack.func_190916_E(), amount);
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(extracted);
        if (!simulate) {
            if (extracted < stack.func_190916_E()) {
                stack.func_190918_g(extracted);
            } else {
                stack = ItemStack.field_190927_a;
            }
            this.inventory.getInventory().set(realSlot, (Object)stack);
            this.inventory.updateGraphics(realSlot);
        }
        return copy;
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot + this.offset);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventory.getInventory().set(slot + this.offset, (Object)stack);
        this.inventory.updateGraphics(slot + this.offset);
    }
}

