/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.util;

import lykrast.prodigytech.core.CommonProxy;
import lykrast.prodigytech.core.ProdigyTech;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static final String CATEGORY_MACHINES = "Machines";
    private static final String CATEGORY_POWER = "Power";
    private static final String CATEGORY_AUTOMATION = "Automation";
    private static final String CATEGORY_ALTAR = "Zorra Altar";
    public static int incineratorProcessTime;
    public static int blowerFurnaceProcessTime;
    public static int rotaryGrinderProcessTime;
    public static int heatSawmillProcessTime;
    public static int foodPurifierBaseTime;
    public static int soldererProcessTime;
    public static int magneticReassemblerProcessTime;
    public static int oreRefineryProcessTime;
    public static int automaticCrystalCutterHarvestTime;
    public static int automaticCrystalCutterIdleTime;
    public static int capacitorChargerChargeTime;
    public static int fuelProcessorBaseTime;
    public static int foodEnricherBaseTime;
    public static int primordialisReactorCycleTime;
    public static int atomicReshaperProcessTime;
    public static float incineratorChance;
    public static float oreRefineryChance;
    public static int rotaryGrinderOreMultiplier;
    public static int oreRefineryOreMultiplier;
    public static boolean autoOreRecipes;
    public static float heatSawmillPlankMultiplier;
    public static float heatSawmillStickMultiplier;
    public static boolean heatSawmillAutoPlankRecipes;
    public static int soldererMaxGold;
    public static int primordialisReactorRequiredInput;
    public static int atomicReshaperMaxPrimordium;
    public static int tartaricStokerTime;
    public static boolean incineratorJEI;
    public static int foodEnricherFoodIncrease;
    public static int foodEnricherFoodCap;
    public static float foodEnricherSaturationIncrease;
    public static float foodEnricherSaturationCap;
    public static float energionGrowthSpeed;
    public static int energionDuration;
    public static int heatCapacitorDuration;
    public static int extractorDelay;
    public static int extractorMaxStack;
    public static int altarBonusLvl;
    public static float altarCostMult;
    public static float altarUnknownMult;

    public static void readConfig() {
        Configuration cfg = CommonProxy.config;
        try {
            cfg.load();
            Config.initGeneralConfig(cfg);
        }
        catch (Exception e) {
            ProdigyTech.logger.warn("Problem loading config file!", (Throwable)e);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_MACHINES, "Machines configuration");
        cfg.addCustomCategoryComment(CATEGORY_POWER, "Power generation configuration");
        cfg.addCustomCategoryComment(CATEGORY_AUTOMATION, "Automation configuration");
        cfg.addCustomCategoryComment(CATEGORY_ALTAR, "Zorra Altar configuration");
        incineratorProcessTime = cfg.getInt("incineratorProcessTime", CATEGORY_MACHINES, 200, 1, 3000, "The base amount of time (in ticks) that the Incinerator takes to process 1 item");
        incineratorChance = cfg.getFloat("incineratorChance", CATEGORY_MACHINES, 1.0f, 0.0f, 1.0f, "The chance that an item burned in the Incinerator gives Ash");
        incineratorJEI = cfg.getBoolean("incineratorJEI", CATEGORY_MACHINES, true, "Show the Incinerator recipe for Ash in JEI");
        blowerFurnaceProcessTime = cfg.getInt("blowerFurnaceProcessTime", CATEGORY_MACHINES, 300, 1, 3000, "The base amount of time (in ticks) that the Blower Furnace takes to process 1 item");
        rotaryGrinderProcessTime = cfg.getInt("rotaryGrinderProcessTime", CATEGORY_MACHINES, 300, 1, 3000, "The base amount of time (in ticks) that the Rotary Grinder takes to process 1 item\nSeveral recipes have shorter or longer processing time, which are all derived from this value");
        rotaryGrinderOreMultiplier = cfg.getInt("rotaryGrinderOreMultiplier", CATEGORY_MACHINES, 2, 1, 10, "By how much ore outputs are multiplied by when passing them through the Rotary Grinder");
        autoOreRecipes = cfg.getBoolean("autoOreRecipes", CATEGORY_MACHINES, true, "Automatically generate Rotary Grinder, Magnetic Reassembler and Ore Refinery recipes to process ores?\nIf false, only recipes for vanilla ores and Prodigy Tech ingots will be registered");
        heatSawmillProcessTime = cfg.getInt("heatSawmillProcessTime", CATEGORY_MACHINES, 200, 1, 3000, "The base amount of time (in ticks) that the Heat Sawmill takes to process 1 item");
        heatSawmillPlankMultiplier = cfg.getFloat("heatSawmillPlankMultiplier", CATEGORY_MACHINES, 1.5f, 1.0f, 10.0f, "Multiplier to the amount of planks the Heat Sawmil can extract from a single log (compared to manual crafting)");
        heatSawmillStickMultiplier = cfg.getFloat("heatSawmillStickMultiplier", CATEGORY_MACHINES, 2.0f, 1.0f, 10.0f, "Multiplier to the amount of planks the Heat Sawmil can extract from a single log (compared to manual crafting)");
        heatSawmillAutoPlankRecipes = cfg.getBoolean("heatSawmillAutoPlankRecipes", CATEGORY_MACHINES, true, "Automatically generate Heat Sawmill recipes to cut wood into planks\nIf false, only recipes for vanilla logs and zorra will be registered");
        foodPurifierBaseTime = cfg.getInt("foodPurifierBaseTime", CATEGORY_MACHINES, 10, 1, 300, "The base amount of time (in ticks) that the Food Purifier takes to process an item, most will take much longer\nFor reference, Beetroots take 2.2x that time, Rotten Flesh takes 4.8x and Steaks 20.8x");
        soldererProcessTime = cfg.getInt("soldererProcessTime", CATEGORY_MACHINES, 400, 1, 3000, "The base amount of time (in ticks) that the Solderer takes to make 1 Crude Circuit\nThe time of all other recipes are derived from this value");
        soldererMaxGold = cfg.getInt("soldererMaxGold", CATEGORY_MACHINES, 81, 9, 20736, "How much gold (in nuggets) can the Solderer hold in its internal buffer");
        magneticReassemblerProcessTime = cfg.getInt("magneticReassemblerProcessTime", CATEGORY_MACHINES, 300, 1, 3000, "The base amount of time (in ticks) that the Magnetic Reassembler takes to process 1 item\nSeveral recipes have shorter or longer processing time, which are all derived from this value");
        oreRefineryProcessTime = cfg.getInt("oreRefineryProcessTime", CATEGORY_MACHINES, 100, 1, 3000, "The base amount of time (in ticks) that the Ore Refinery takes to process 1 item");
        oreRefineryOreMultiplier = cfg.getInt("oreRefineryOreMultiplier", CATEGORY_MACHINES, 2, 1, 10, "By how much ore outputs are multiplied by when passing them through the Ore Refinery");
        oreRefineryChance = cfg.getFloat("oreRefineryChance", CATEGORY_MACHINES, 0.25f, 0.0f, 1.0f, "The chance the Ore Refinery produces a secondary ore");
        automaticCrystalCutterHarvestTime = cfg.getInt("automaticCrystalCutterHarvestTime", CATEGORY_MACHINES, 100, 1, 3000, "The base amount of time (in ticks) that the Automatic Crystal Cutter takes to harvest 1 stage");
        automaticCrystalCutterIdleTime = cfg.getInt("automaticCrystalCutterIdleTime", CATEGORY_MACHINES, 60, 1, 200, "The time (in ticks) between 2 checks of the Automatic Crystal Cutter\n1 means every tick, 20 means once every second and so on\nLower value will make them more reactive to crystal growing, but will make them sligtly laggier when idle");
        capacitorChargerChargeTime = cfg.getInt("capacitorChargerChargeTime", CATEGORY_MACHINES, 30, 20, 200, "The base amount of time (in ticks) that the Heat Accumulator takes to charge 20 ticks of an Heat Capacitor");
        fuelProcessorBaseTime = cfg.getInt("fuelProcessorBaseTime", CATEGORY_MACHINES, 60, 1, 3000, "The base amount of time (in ticks) that the Fuel Processor takes to process a fuel that yields 1 Fuel Pellet\nTime for longer lasting fuels is derived from this value");
        foodEnricherBaseTime = cfg.getInt("foodEnricherBaseTime", CATEGORY_MACHINES, 20, 1, 50, "A multiplier to the amount of time the Food Enricher takes to process an item\nActual time varies heavily depending on the enriched food and how much it enriches\nbut is always much higher than this value");
        foodEnricherFoodIncrease = cfg.getInt("foodEnricherFoodIncrease", CATEGORY_MACHINES, 2, 1, 20, "How much does one Food Enricher operation increases the food value (in half shanks)");
        foodEnricherFoodCap = cfg.getInt("foodEnricherFoodCap", CATEGORY_MACHINES, 20, 1, 20, "The Food Enricher will not increase a food's food value beyond this amount (in half shanks)");
        foodEnricherSaturationIncrease = cfg.getFloat("foodEnricherSaturationIncrease", CATEGORY_MACHINES, 0.1f, 0.0f, 2.0f, "How much does one Food Enricher operation increases the saturation ratio");
        foodEnricherSaturationCap = cfg.getFloat("foodEnricherSaturationCap", CATEGORY_MACHINES, 1.2f, 0.0f, 10.0f, "The Food Enricher will not increase a food's saturation ratio beyond this amount");
        primordialisReactorCycleTime = cfg.getInt("primordialisReactorCycleTime", CATEGORY_MACHINES, 60, 1, 3000, "The base amount of time (in ticks) that the Primordialis Reactor takes to make 1 cycle");
        primordialisReactorRequiredInput = cfg.getInt("primordialisReactorRequiredInput", CATEGORY_MACHINES, 576, 9, 5760, "How many the Primordialis Reactor needs to consume to make 1 Primordium\nNote that this can be divided by up to 9 by putting different items\nThis also means the number of cycles required ranges from this number to 1/81");
        atomicReshaperProcessTime = cfg.getInt("atomicReshaperProcessTime", CATEGORY_MACHINES, 200, 1, 3000, "The base amount of time (in ticks) that the Atomic Reassembler takes to process 1 item\nSeveral recipes have shorter or longer processing time, which are all derived from this value");
        atomicReshaperMaxPrimordium = cfg.getInt("atomicReshaperMaxPrimordium", CATEGORY_MACHINES, 4, 1, 64, "How many Primordium items can the Atomic Reshaper hold in its internal buffer");
        tartaricStokerTime = cfg.getInt("tartaricStokerTime", CATEGORY_MACHINES, 1600, 1, Short.MAX_VALUE, "The base amount of time (in ticks) that 1 Tartaric Stoker lasts in the Tartaric Aeroheater");
        energionGrowthSpeed = cfg.getFloat("energionGrowthSpeed", CATEGORY_POWER, 4.0f, 0.1f, 25.0f, "A modifier to how fast Energion Crystals grow\n2 is about the growth of a single wheat on dry farmland, 4 is about single wheat on wet farmland");
        energionDuration = cfg.getInt("energionDuration", CATEGORY_POWER, 2000, 20, 1728000, "The time (in ticks) one Energion Dust lasts in the Energion Aeroheater");
        heatCapacitorDuration = cfg.getInt("heatCapacitorDuration", CATEGORY_POWER, 12000, 20, 1728000, "The time (in ticks) a fully charged Heat Capacitor lasts");
        extractorDelay = cfg.getInt("extractorDelay", CATEGORY_AUTOMATION, 10, 1, 200, "The time (in ticks) between 2 push/pulls of an Extractor\n1 means every tick, 20 means once every second and so on");
        extractorMaxStack = cfg.getInt("extractorMaxStack", CATEGORY_AUTOMATION, 64, 1, 64, "How many items from a stack an Extractor can push/pull at once");
        altarCostMult = cfg.getFloat("altarCostMult", CATEGORY_ALTAR, 0.6f, 0.0f, 10.0f, "A multiplier applied to all enchantment costs on the Zorra Altar\nFor example 1.5 means that everything costs 50% more than the base amount");
        altarUnknownMult = cfg.getFloat("altarUnknownMult", CATEGORY_ALTAR, 0.5f, 0.0f, 10.0f, "Cost multiplier for the unknown option\nFor example 0.5 means that the unknown option only costs 50% of the normal cost");
        altarBonusLvl = cfg.getInt("altarBonusLvl", CATEGORY_ALTAR, 3, 0, 100, "How many levels beyond the normal maximum can the Zorra Altar apply enchantments\nSome enchantments don't take account of this limit");
    }
}

