/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockWormholeFunnel;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.IHotAir;
import lykrast.prodigytech.common.util.TemperatureHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileWormholeFunnel
extends TileEntity
implements IHotAir {
    private boolean down;
    private BlockPos linkedPos;
    private TileWormholeFunnel linkedTile;
    private boolean hasLooped = false;

    public void setDown(boolean isDown) {
        this.down = isDown;
    }

    public boolean isInput() {
        return this.down;
    }

    public boolean isLinked() {
        return this.linkedPos != null;
    }

    public boolean isActive() {
        return this.linkedTile != null;
    }

    public BlockPos getLinkedPos() {
        return this.linkedPos;
    }

    public boolean isInRange(BlockPos target) {
        return this.distance(this.field_174879_c.func_177958_n(), target.func_177958_n()) <= 8 && this.distance(this.field_174879_c.func_177956_o(), target.func_177956_o()) <= 8 && this.distance(this.field_174879_c.func_177952_p(), target.func_177952_p()) <= 8;
    }

    private int distance(int a, int b) {
        return Math.abs(a - b);
    }

    public boolean createLink(TileWormholeFunnel other) {
        if (this.down == other.down) {
            return false;
        }
        this.destroyLink(true);
        other.destroyLink(true);
        this.linkedPos = other.field_174879_c;
        this.linkedTile = other;
        other.linkedPos = this.field_174879_c;
        other.linkedTile = this;
        BlockWormholeFunnel.setActive(true, this.field_145850_b, this.field_174879_c);
        BlockWormholeFunnel.setActive(true, this.field_145850_b, this.linkedPos);
        this.func_70296_d();
        return true;
    }

    private void restoreLink(TileWormholeFunnel other) {
        if (this.down == other.down || this.linkedPos == null || other.linkedPos == null) {
            this.destroyLink(false);
        } else {
            this.linkedTile = other;
            other.linkedTile = this;
        }
    }

    public void destroyLink(boolean causeUpdate) {
        if (this.linkedPos == null) {
            return;
        }
        if (this.linkedTile != null) {
            BlockWormholeFunnel.setActive(false, this.field_145850_b, this.field_174879_c);
            BlockWormholeFunnel.setActive(false, this.field_145850_b, this.linkedPos);
            this.linkedTile.linkedPos = null;
            this.linkedTile.linkedTile = null;
            this.linkedPos = null;
            this.linkedTile = null;
        } else {
            BlockWormholeFunnel.setActive(false, this.field_145850_b, this.field_174879_c);
            this.linkedPos = null;
        }
        this.func_70296_d();
    }

    private void sleepLink() {
        if (this.linkedPos == null || this.linkedTile == null) {
            return;
        }
        this.linkedTile.linkedTile = null;
        this.linkedTile = null;
    }

    public void func_145843_s() {
        this.sleepLink();
        super.func_145843_s();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (!(capability != CapabilityHotAir.HOT_AIR || facing != EnumFacing.UP && facing != null || this.down)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (!(capability != CapabilityHotAir.HOT_AIR || facing != EnumFacing.UP && facing != null || this.down)) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getOutAirTemperature() {
        if (this.hasLooped) {
            return 30;
        }
        this.hasLooped = true;
        int temp = this.down ? TemperatureHelper.getBlockTemp(this.field_145850_b, this.field_174879_c.func_177977_b()) : (this.isActive() ? this.linkedTile.getOutAirTemperature() : 30);
        this.hasLooped = false;
        return temp;
    }

    public void onLoad() {
        if (!this.isLinked()) {
            return;
        }
        TileEntity found = this.field_145850_b.func_175625_s(this.linkedPos);
        if (found != null && found instanceof TileWormholeFunnel) {
            this.restoreLink((TileWormholeFunnel)found);
        } else if (this.field_145850_b.func_175667_e(this.linkedPos)) {
            this.destroyLink(false);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.down = compound.func_74767_n("Down");
        if (compound.func_74764_b("Linked")) {
            this.linkedPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("Linked"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Down", this.down);
        if (this.linkedPos != null) {
            compound.func_74782_a("Linked", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.linkedPos));
        }
        return compound;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            return true;
        }
        return oldState.func_177229_b((IProperty)BlockWormholeFunnel.DOWN) != newState.func_177229_b((IProperty)BlockWormholeFunnel.DOWN);
    }
}

