/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockMachineActiveable;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirMachine;
import lykrast.prodigytech.common.recipe.SoldererManager;
import lykrast.prodigytech.common.tileentity.IProcessing;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.IProdigyInventory;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileSolderer
extends TileMachineInventory
implements ITickable,
IProcessing {
    private int processTime;
    private int processTimeMax;
    private HotAirMachine hotAir;
    private int gold;
    private SoldererManager.SoldererRecipe cachedRecipe;
    private ProdigyInventoryHandler invHandler = new ProdigyInventoryHandler((IProdigyInventory)this, 5, 0, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, true});

    public TileSolderer() {
        super(5);
        this.hotAir = new HotAirMachine(this, 0.75f);
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "solderer";
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return SoldererManager.isValidPattern(stack);
        }
        if (index == 1) {
            return SoldererManager.getGoldAmount(stack) > 0;
        }
        if (index == 2) {
            return SoldererManager.isValidAdditive(stack);
        }
        if (index == 3) {
            return SoldererManager.isPlate(stack);
        }
        return false;
    }

    private int canSmeltGold() {
        if (this.func_70301_a(1).func_190926_b() || this.hotAir.getInAirTemperature() < 125) {
            return 0;
        }
        int amount = SoldererManager.getGoldAmount(this.func_70301_a(1));
        if (amount > Config.soldererMaxGold - this.gold) {
            return 0;
        }
        return amount;
    }

    private void updateCachedRecipe() {
        if (this.cachedRecipe == null) {
            this.cachedRecipe = SoldererManager.findRecipe(this.func_70301_a(0), this.func_70301_a(2), this.gold);
        } else if (!this.cachedRecipe.isValidInput(this.func_70301_a(0), this.func_70301_a(2), this.gold)) {
            this.cachedRecipe = SoldererManager.findRecipe(this.func_70301_a(0), this.func_70301_a(2), this.gold);
            this.processTimeMax = 0;
            this.processTime = 0;
        }
    }

    private boolean canProcess() {
        if (this.func_70301_a(0).func_190926_b() || this.func_70301_a(3).func_190926_b() || this.hotAir.getInAirTemperature() < 125) {
            this.cachedRecipe = null;
            return false;
        }
        this.updateCachedRecipe();
        if (this.cachedRecipe == null) {
            return false;
        }
        ItemStack itemstack = this.cachedRecipe.getOutput();
        ItemStack itemstack1 = this.func_70301_a(4);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public void func_73660_a() {
        boolean flag = this.isProcessing();
        boolean flag1 = false;
        this.process();
        if (!this.field_145850_b.field_72995_K) {
            this.hotAir.updateInTemperature(this.field_145850_b, this.field_174879_c);
            int goldAmount = this.canSmeltGold();
            if (goldAmount > 0) {
                this.gold += goldAmount;
                this.func_70301_a(1).func_190918_g(1);
            }
            if (this.canProcess()) {
                if (this.processTimeMax <= 0) {
                    this.processTime = this.processTimeMax = this.cachedRecipe.getTimeProcessing();
                } else if (this.processTime <= 0) {
                    this.smelt();
                    flag1 = true;
                    if (this.canProcess()) {
                        this.processTime = this.processTimeMax = this.cachedRecipe.getTimeProcessing();
                    } else {
                        this.processTimeMax = 0;
                        this.processTime = 0;
                    }
                }
            } else if (this.processTime >= this.processTimeMax) {
                this.processTimeMax = 0;
                this.processTime = 0;
            }
            this.hotAir.updateOutTemperature();
            if (flag != this.isProcessing()) {
                flag1 = true;
                BlockMachineActiveable.setState(this.isProcessing(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private void smelt() {
        this.updateCachedRecipe();
        ItemStack itemstack1 = this.cachedRecipe.getOutput();
        ItemStack itemstack2 = this.func_70301_a(4);
        if (itemstack2.func_190926_b()) {
            this.func_70299_a(4, itemstack1);
        } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
            itemstack2.func_190917_f(itemstack1.func_190916_E());
        }
        if (this.cachedRecipe.requiresAdditive()) {
            this.func_70301_a(2).func_190918_g(this.cachedRecipe.getAdditive().func_190916_E());
        }
        this.func_70301_a(3).func_190918_g(1);
        this.gold -= this.cachedRecipe.getGoldAmount();
    }

    private int getProcessSpeed() {
        return (int)((double)this.hotAir.getInAirTemperature() / 12.5);
    }

    @Override
    public boolean isProcessing() {
        return this.processTime > 0;
    }

    @Override
    public int getProgressLeft() {
        return this.processTime;
    }

    @Override
    public int getMaxProgress() {
        return this.processTimeMax;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isProcessing(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    private void process() {
        if (this.isProcessing()) {
            this.processTime = this.canProcess() ? (this.processTime -= this.getProcessSpeed()) : this.processTimeMax;
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.processTime;
            }
            case 1: {
                return this.processTimeMax;
            }
            case 2: {
                return this.hotAir.getInAirTemperature();
            }
            case 3: {
                return this.hotAir.getOutAirTemperature();
            }
            case 4: {
                return this.gold;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.processTime = value;
                break;
            }
            case 1: {
                this.processTimeMax = value;
                break;
            }
            case 2: {
                this.hotAir.setTemperature(value);
                break;
            }
            case 3: {
                this.hotAir.setOutAirTemperature(value);
                break;
            }
            case 4: {
                this.gold = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 5;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return true;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return (T)this.invHandler;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return (T)this.hotAir;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.processTime = compound.func_74762_e("ProcessTime");
        this.processTimeMax = compound.func_74762_e("ProcessTimeMax");
        this.hotAir.deserializeNBT(compound.func_74775_l("HotAir"));
        this.gold = compound.func_74762_e("Gold");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("ProcessTime", this.processTime);
        compound.func_74768_a("ProcessTimeMax", this.processTimeMax);
        compound.func_74782_a("HotAir", (NBTBase)this.hotAir.serializeNBT());
        compound.func_74768_a("Gold", this.gold);
        return compound;
    }
}

