/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockMachineActiveable;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirMachine;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.PrimordialisReactorManager;
import lykrast.prodigytech.common.tileentity.IProcessing;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.IProdigyInventory;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TilePrimordialisReactor
extends TileMachineInventory
implements ITickable,
IProcessing {
    private int progressCycle;
    private int progressPrimordium;
    private HotAirMachine hotAir;
    private IItemHandlerModifiable invHandler = new ProdigyInventoryHandler((IProdigyInventory)this, 10, 0, new boolean[]{true, true, true, true, true, true, true, true, true, false}, new boolean[]{false, false, false, false, false, false, false, false, false, true});

    public TilePrimordialisReactor() {
        super(10);
        this.hotAir = new HotAirMachine(this, 0.5f);
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "primordialis_reactor";
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index < 9) {
            return PrimordialisReactorManager.isValidInput(stack);
        }
        return false;
    }

    private boolean canProcess() {
        if (this.hotAir.getInAirTemperature() < 250) {
            return false;
        }
        boolean content = false;
        for (int i = 0; i < 9; ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            content = true;
            break;
        }
        if (!content) {
            return false;
        }
        ItemStack output = this.func_70301_a(9);
        if (output.func_190926_b()) {
            return true;
        }
        return output.func_190916_E() < this.func_70297_j_() && output.func_190916_E() < output.func_77976_d();
    }

    public void func_73660_a() {
        boolean flag = this.isProcessing();
        boolean flag1 = false;
        this.process();
        if (!this.field_145850_b.field_72995_K) {
            this.hotAir.updateInTemperature(this.field_145850_b, this.field_174879_c);
            if (this.canProcess()) {
                if (this.progressCycle <= 0) {
                    this.progressCycle = 1;
                } else if (this.progressCycle > Config.primordialisReactorCycleTime * 10) {
                    this.cycle();
                    if (this.progressPrimordium >= Config.primordialisReactorRequiredInput) {
                        this.makePrimordium();
                    }
                    flag1 = true;
                    if (this.canProcess()) {
                        this.progressCycle = 1;
                    }
                }
            } else if (this.progressCycle > 0) {
                this.progressCycle = 0;
            }
            this.hotAir.updateOutTemperature();
            if (flag != this.isProcessing()) {
                flag1 = true;
                BlockMachineActiveable.setState(this.isProcessing(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private void cycle() {
        ItemStack[] collected = new ItemStack[9];
        int amount = 0;
        block0: for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            for (int j = 0; j < amount; ++j) {
                if (collected[j].func_77969_a(stack)) continue block0;
            }
            collected[amount] = stack.func_77979_a(1);
            ++amount;
        }
        this.progressPrimordium += amount * amount;
    }

    private void makePrimordium() {
        ItemStack existing = this.func_70301_a(9);
        if (existing.func_190926_b()) {
            this.func_70299_a(9, new ItemStack(ModItems.primordium));
        } else if (existing.func_77973_b() == ModItems.primordium) {
            existing.func_190917_f(1);
        }
        this.progressPrimordium = 0;
    }

    private int getProcessSpeed() {
        return this.hotAir.getInAirTemperature() / 25;
    }

    @Override
    public boolean isProcessing() {
        return this.progressCycle > 0;
    }

    @Override
    public int getProgressLeft() {
        return Config.primordialisReactorRequiredInput - this.progressPrimordium;
    }

    @Override
    public int getMaxProgress() {
        return Config.primordialisReactorRequiredInput;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isProcessing(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    private void process() {
        if (this.isProcessing()) {
            this.progressCycle = this.canProcess() ? (this.progressCycle += this.getProcessSpeed()) : 0;
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.progressCycle;
            }
            case 1: {
                return this.progressPrimordium;
            }
            case 2: {
                return this.hotAir.getInAirTemperature();
            }
            case 3: {
                return this.hotAir.getOutAirTemperature();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.progressCycle = value;
                break;
            }
            case 1: {
                this.progressPrimordium = value;
                break;
            }
            case 2: {
                this.hotAir.setTemperature(value);
                break;
            }
            case 3: {
                this.hotAir.setOutAirTemperature(value);
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 4;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return true;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return (T)this.invHandler;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return (T)this.hotAir;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.progressCycle = compound.func_74762_e("ProgressCycle");
        this.progressPrimordium = compound.func_74762_e("ProgressPrimordium");
        this.hotAir.deserializeNBT(compound.func_74775_l("HotAir"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("ProgressCycle", this.progressCycle);
        compound.func_74768_a("ProgressPrimordium", this.progressPrimordium);
        compound.func_74782_a("HotAir", (NBTBase)this.hotAir.serializeNBT());
        return compound;
    }
}

