/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirMachine;
import lykrast.prodigytech.common.tileentity.IProcessing;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TileHotAirMachine
extends TileMachineInventory
implements ITickable,
IProcessing {
    protected int processTime;
    protected int processTimeMax;
    protected HotAirMachine hotAir;
    private IItemHandlerModifiable invHandler = this.createInventoryHandler();

    public TileHotAirMachine(int slots, float outputMultiplier) {
        super(slots);
        this.hotAir = new HotAirMachine(this, outputMultiplier);
    }

    protected abstract int getProcessSpeed();

    protected abstract boolean canProcess();

    @Override
    public boolean isProcessing() {
        return this.processTime > 0;
    }

    @Override
    public int getProgressLeft() {
        return this.processTime;
    }

    @Override
    public int getMaxProgress() {
        return this.processTimeMax;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isProcessing(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    protected void process() {
        if (this.isProcessing()) {
            this.processTime = this.canProcess() ? (this.processTime -= this.getProcessSpeed()) : this.processTimeMax;
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.processTime;
            }
            case 1: {
                return this.processTimeMax;
            }
            case 2: {
                return this.hotAir.getInAirTemperature();
            }
            case 3: {
                return this.hotAir.getOutAirTemperature();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.processTime = value;
                break;
            }
            case 1: {
                this.processTimeMax = value;
                break;
            }
            case 2: {
                this.hotAir.setTemperature(value);
                break;
            }
            case 3: {
                this.hotAir.setOutAirTemperature(value);
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 4;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return true;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    protected abstract IItemHandlerModifiable createInventoryHandler();

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return (T)this.invHandler;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return (T)this.hotAir;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.processTime = compound.func_74762_e("ProcessTime");
        this.processTimeMax = compound.func_74762_e("ProcessTimeMax");
        this.hotAir.deserializeNBT(compound.func_74775_l("HotAir"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("ProcessTime", this.processTime);
        compound.func_74768_a("ProcessTimeMax", this.processTimeMax);
        compound.func_74782_a("HotAir", (NBTBase)this.hotAir.serializeNBT());
        return compound;
    }
}

