/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import lykrast.prodigytech.common.block.BlockMachineActiveable;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.tileentity.TileHotAirMachineSimple;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileFuelProcessor
extends TileHotAirMachineSimple {
    private static final List<Item> BLACKLIST = new ArrayList<Item>();
    private static final int TRESHOLD_4 = 12800;
    private static final int TRESHOLD_16 = 51200;
    private static final int TRESHOLD_64 = 204800;
    private static final int CAP = 819200;
    private ItemStack lastInput = ItemStack.field_190927_a;

    public static void initBlacklist() {
        BLACKLIST.add(ModItems.fuelPellet1);
        BLACKLIST.add(ModItems.fuelPellet4);
        BLACKLIST.add(ModItems.fuelPellet16);
        BLACKLIST.add(ModItems.fuelPellet64);
    }

    public static boolean isValidInput(ItemStack stack) {
        int burn = TileEntityFurnace.func_145952_a((ItemStack)stack);
        return burn >= 200 && burn <= 819200 && stack.func_77973_b().getContainerItem(stack).func_190926_b() && !BLACKLIST.contains(stack.func_77973_b());
    }

    public static int getProcessTime(ItemStack stack) {
        return (int)(Math.sqrt(TileEntityFurnace.func_145952_a((ItemStack)stack) / 200) * (double)Config.fuelProcessorBaseTime);
    }

    public static int getPelletsAmount(ItemStack stack) {
        int burn = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (burn <= 12800) {
            return burn / 200;
        }
        if (burn <= 51200) {
            return burn / 800;
        }
        if (burn <= 204800) {
            return burn / 3200;
        }
        return burn / 12800;
    }

    public static Item getResultingPellet(ItemStack stack) {
        int burn = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (burn <= 12800) {
            return ModItems.fuelPellet1;
        }
        if (burn <= 51200) {
            return ModItems.fuelPellet4;
        }
        if (burn <= 204800) {
            return ModItems.fuelPellet16;
        }
        return ModItems.fuelPellet64;
    }

    public TileFuelProcessor() {
        super(0.8f);
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "fuel_processor";
    }

    private void updateCachedResult() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack input = this.func_70301_a(0);
        if (input.func_190926_b()) {
            this.lastInput = ItemStack.field_190927_a;
        } else if (this.lastInput.func_190926_b()) {
            this.lastInput = input;
        } else if (input != this.lastInput) {
            this.lastInput = input;
            this.processTimeMax = 0;
            this.processTime = 0;
        }
    }

    @Override
    protected boolean canProcess() {
        if (this.func_70301_a(0).func_190926_b() || this.hotAir.getInAirTemperature() < 80) {
            return false;
        }
        this.updateCachedResult();
        ItemStack curOutput = this.func_70301_a(1);
        if (curOutput.func_190926_b()) {
            return true;
        }
        ItemStack input = this.func_70301_a(0);
        if (curOutput.func_77973_b() != TileFuelProcessor.getResultingPellet(input)) {
            return false;
        }
        int amount = TileFuelProcessor.getPelletsAmount(input);
        return curOutput.func_190916_E() + amount <= this.func_70297_j_() && curOutput.func_190916_E() + amount <= 64;
    }

    @Override
    protected int getProcessSpeed() {
        return this.hotAir.getInAirTemperature() / 8;
    }

    public void func_73660_a() {
        boolean wasProcessing = this.isProcessing();
        boolean shouldDirty = false;
        this.process();
        if (!this.field_145850_b.field_72995_K) {
            this.hotAir.updateInTemperature(this.field_145850_b, this.field_174879_c);
            if (this.canProcess()) {
                if (this.processTimeMax <= 0) {
                    this.processTime = this.processTimeMax = TileFuelProcessor.getProcessTime(this.func_70301_a(0)) * 10;
                } else if (this.processTime <= 0) {
                    this.smelt();
                    shouldDirty = true;
                    if (this.canProcess()) {
                        this.processTime = this.processTimeMax = TileFuelProcessor.getProcessTime(this.func_70301_a(0)) * 10;
                    } else {
                        this.processTimeMax = 0;
                        this.processTime = 0;
                    }
                }
            } else if (this.processTime >= this.processTimeMax) {
                this.updateCachedResult();
                this.processTimeMax = 0;
                this.processTime = 0;
            }
            this.hotAir.updateOutTemperature();
            if (wasProcessing != this.isProcessing()) {
                shouldDirty = true;
                BlockMachineActiveable.setState(this.isProcessing(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (shouldDirty) {
            this.func_70296_d();
        }
    }

    private void smelt() {
        ItemStack input = this.func_70301_a(0);
        ItemStack curOutput = this.func_70301_a(1);
        int amount = TileFuelProcessor.getPelletsAmount(input);
        if (curOutput.func_190926_b()) {
            this.func_70299_a(1, new ItemStack(TileFuelProcessor.getResultingPellet(input), amount));
        } else {
            curOutput.func_190917_f(amount);
        }
        input.func_190918_g(1);
        this.updateCachedResult();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return TileFuelProcessor.isValidInput(stack);
        }
        return false;
    }
}

