/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockMachineActiveable;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.item.ItemFoodPurified;
import lykrast.prodigytech.common.tileentity.TileHotAirMachineSimple;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;

public class TileFoodEnricher
extends TileHotAirMachineSimple {
    private ItemStack cachedResult;
    private ItemStack lastInput = ItemStack.field_190927_a;

    public static boolean isValidInput(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.purifiedFood) {
            return false;
        }
        ItemFood item = (ItemFood)stack.func_77973_b();
        return item.func_150905_g(stack) < Config.foodEnricherFoodCap || !(item.func_150906_h(stack) >= Config.foodEnricherSaturationCap);
    }

    public static int getProcessTime(ItemStack stack) {
        ItemFood food = (ItemFood)stack.func_77973_b();
        int value = food.func_150905_g(stack);
        int valueInc = Config.foodEnricherFoodIncrease;
        float saturation = food.func_150906_h(stack);
        float saturationInc = Config.foodEnricherSaturationIncrease;
        double time = 2.0f * ((float)value * saturationInc + saturation * (float)valueInc + (float)valueInc * saturationInc) + (float)valueInc;
        time *= time;
        return (int)(time * (double)Config.foodEnricherBaseTime);
    }

    public static ItemStack enrich(ItemStack stack) {
        ItemFood food = (ItemFood)stack.func_77973_b();
        int value = food.func_150905_g(stack);
        float saturation = food.func_150906_h(stack);
        if (value < Config.foodEnricherFoodCap) {
            value = Math.min(value + Config.foodEnricherFoodIncrease, Config.foodEnricherFoodCap);
        }
        if (saturation < Config.foodEnricherSaturationCap) {
            saturation = Math.min(saturation + Config.foodEnricherSaturationIncrease, Config.foodEnricherSaturationCap);
        }
        return ItemFoodPurified.make(value, saturation);
    }

    public TileFoodEnricher() {
        super(0.75f);
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "food_enricher";
    }

    private void updateCachedResult() {
        ItemStack input = this.func_70301_a(0);
        if (input.func_190926_b()) {
            this.cachedResult = null;
            this.lastInput = ItemStack.field_190927_a;
        } else if (this.lastInput.func_190926_b()) {
            this.lastInput = input;
            this.cachedResult = TileFoodEnricher.enrich(input);
        } else if (input != this.lastInput) {
            this.lastInput = input;
            this.cachedResult = TileFoodEnricher.enrich(input);
            if (!this.field_145850_b.field_72995_K) {
                this.processTimeMax = 0;
                this.processTime = 0;
            }
        } else if (this.cachedResult == null) {
            this.cachedResult = TileFoodEnricher.enrich(input);
        }
    }

    @Override
    protected boolean canProcess() {
        if (this.func_70301_a(0).func_190926_b() || this.hotAir.getInAirTemperature() < 125) {
            return false;
        }
        this.updateCachedResult();
        ItemStack curOutput = this.func_70301_a(1);
        return curOutput.func_190926_b() || ItemStack.func_77970_a((ItemStack)curOutput, (ItemStack)this.cachedResult) && curOutput.func_190916_E() + 1 <= ModItems.purifiedFood.func_77639_j();
    }

    @Override
    protected int getProcessSpeed() {
        return (int)((double)this.hotAir.getInAirTemperature() / 12.5);
    }

    public void func_73660_a() {
        boolean wasProcessing = this.isProcessing();
        boolean shouldDirty = false;
        this.process();
        if (!this.field_145850_b.field_72995_K) {
            this.hotAir.updateInTemperature(this.field_145850_b, this.field_174879_c);
            if (this.canProcess()) {
                if (this.processTimeMax <= 0) {
                    this.processTime = this.processTimeMax = TileFoodEnricher.getProcessTime(this.func_70301_a(0)) * 10;
                } else if (this.processTime <= 0) {
                    this.smelt();
                    shouldDirty = true;
                    if (this.canProcess()) {
                        this.processTime = this.processTimeMax = TileFoodEnricher.getProcessTime(this.func_70301_a(0)) * 10;
                    } else {
                        this.processTimeMax = 0;
                        this.processTime = 0;
                    }
                }
            } else if (this.processTime >= this.processTimeMax) {
                this.updateCachedResult();
                this.processTimeMax = 0;
                this.processTime = 0;
            }
            this.hotAir.updateOutTemperature();
            if (wasProcessing != this.isProcessing()) {
                shouldDirty = true;
                BlockMachineActiveable.setState(this.isProcessing(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (shouldDirty) {
            this.func_70296_d();
        }
    }

    private void smelt() {
        ItemStack input = this.func_70301_a(0);
        ItemStack curOutput = this.func_70301_a(1);
        if (curOutput.func_190926_b()) {
            this.func_70299_a(1, TileFoodEnricher.enrich(input));
        } else {
            curOutput.func_190917_f(1);
        }
        input.func_190918_g(1);
        this.updateCachedResult();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return TileFoodEnricher.isValidInput(stack);
        }
        return false;
    }
}

