/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockLinearExtractor;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.IProdigyInventory;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileExtractor
extends TileMachineInventory
implements ITickable {
    protected short clockTime;
    private ProdigyInventoryHandler invHandler = new ProdigyInventoryHandler((IProdigyInventory)this, 1, 0, true, true);

    public TileExtractor() {
        super(1);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.clockTime <= 1) {
                if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
                    this.clockTime = (short)Config.extractorDelay;
                    this.work(BlockLinearExtractor.getFacing(this.func_145832_p()));
                }
            } else {
                this.clockTime = (short)(this.clockTime - 1);
            }
        }
    }

    protected abstract void work(EnumFacing var1);

    protected boolean hasItem() {
        return !this.func_70301_a(0).func_190926_b();
    }

    protected boolean push(EnumFacing facing) {
        if (!this.hasItem()) {
            return false;
        }
        IItemHandler handler = this.getAdjacentTileCapability(facing);
        if (handler == null) {
            return false;
        }
        ItemStack inside = this.func_70301_a(0);
        int initialCount = inside.func_190916_E();
        ItemStack toPush = inside.func_77979_a(Config.extractorMaxStack);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!(toPush = handler.insertItem(i, toPush, false)).func_190926_b()) continue;
            return true;
        }
        if (inside.func_190926_b()) {
            this.func_70299_a(0, toPush);
            return toPush.func_190916_E() < initialCount;
        }
        inside.func_190917_f(toPush.func_190916_E());
        return inside.func_190916_E() < initialCount;
    }

    protected boolean pull(EnumFacing facing) {
        IItemHandler handler = this.getAdjacentTileCapability(facing);
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack remainder;
            ItemStack extracted = handler.extractItem(i, Config.extractorMaxStack, true);
            if (extracted.func_190926_b() || ItemStack.func_77989_b((ItemStack)extracted, (ItemStack)(remainder = this.invHandler.insertItem(0, extracted, true)))) continue;
            int amount = extracted.func_190916_E();
            if (!remainder.func_190926_b()) {
                amount -= remainder.func_190916_E();
            }
            this.invHandler.insertItem(0, handler.extractItem(i, amount, false), false);
            return true;
        }
        return false;
    }

    private IItemHandler getAdjacentTileCapability(EnumFacing facing) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (tile == null) {
            return null;
        }
        return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.clockTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.clockTime = (short)value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 1;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.invHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.clockTime = compound.func_74765_d("ClockTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("ClockTime", this.clockTime);
        return compound;
    }
}

