/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.recipe.ExplosionFurnaceManager;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import lykrast.prodigytech.common.util.IProdigyInventory;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileExplosionFurnace
extends TileMachineInventory {
    private ProdigyInventoryHandler invHandler = new ProdigyInventoryHandler((IProdigyInventory)this, 9, 0, new boolean[]{true, true, true, true, true, true, false, false, false}, new boolean[]{false, false, false, false, false, false, true, true, true});

    public TileExplosionFurnace() {
        super(9);
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "explosion_furnace";
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void process(EnumFacing facing) {
        ItemStack exp = this.func_70301_a(0);
        ItemStack damp = this.func_70301_a(1);
        if (exp.func_190926_b()) return;
        ExplosionFurnaceManager.Explosive explosive = ExplosionFurnaceManager.findExplosive(exp);
        ExplosionFurnaceManager.Dampener dampener = ExplosionFurnaceManager.findDampener(damp);
        if (explosive == null) return;
        int power = explosive.getPower(exp);
        int dampened = dampener != null ? dampener.getDampening(damp) : 0;
        float efficiency = 1.0f;
        if (dampened < power) {
            efficiency = 1.0f - (float)(power - dampened) / (float)power;
        } else {
            power = Math.max(0, power * 2 - dampened);
        }
        this.func_70304_b(0);
        this.func_70304_b(1);
        BlockPos origin = this.field_174879_c.func_177972_a(facing);
        this.field_145850_b.func_72876_a(null, (double)origin.func_177958_n() + 0.5, (double)origin.func_177956_o() + 0.5, (double)origin.func_177952_p() + 0.5, Math.min((float)power / 720.0f, 2.0f), false);
        ItemStack reagent = this.func_70301_a(5);
        int slot = 2;
        while (true) {
            block10: {
                if (slot > 4) {
                    this.func_70296_d();
                    return;
                }
                ItemStack stack = this.func_70301_a(slot);
                if (stack.func_190926_b()) break block10;
                boolean shouldCraft = true;
                while (shouldCraft) {
                    shouldCraft = false;
                    ExplosionFurnaceManager.ExplosionFurnaceRecipe recipe = ExplosionFurnaceManager.findRecipe(stack, reagent);
                    if (recipe == null || recipe.getRequiredPower() > power) continue;
                    ItemStack output = recipe.getOutput();
                    int inCount = recipe.getInputCount();
                    int outCount = output.func_190916_E();
                    int cost = recipe.getRequiredPower();
                    output.func_190920_e(0);
                    boolean requireReagent = recipe.needReagent();
                    int craftLeft = 0;
                    while (!shouldCraft && stack.func_190916_E() >= inCount && power >= cost) {
                        block11: {
                            block12: {
                                if (!requireReagent) break block11;
                                if (craftLeft > 0) break block12;
                                if (!reagent.func_190926_b() && recipe.isValidReagent(reagent)) {
                                    reagent.func_190918_g(1);
                                    craftLeft += recipe.getCraftPerReagent() - 1;
                                    if (reagent.func_190916_E() <= 0) {
                                        this.func_70304_b(5);
                                        reagent = this.func_70301_a(5);
                                    }
                                    break block11;
                                } else {
                                    shouldCraft = true;
                                    break;
                                }
                            }
                            --craftLeft;
                        }
                        stack.func_190918_g(inCount);
                        power -= cost;
                        output.func_190917_f(outCount);
                    }
                    if (stack.func_190916_E() <= 0) {
                        this.func_70304_b(slot);
                    }
                    output.func_190920_e((int)((float)output.func_190916_E() * efficiency));
                    if (output.func_190916_E() <= 0) continue;
                    this.fillOutput(output, origin);
                }
            }
            ++slot;
        }
    }

    private void fillOutput(ItemStack stack, BlockPos dump) {
        for (int slot = 6; slot <= 8; ++slot) {
            int old;
            ItemStack slotStack = this.func_70301_a(slot);
            if (slotStack.func_190926_b()) {
                old = stack.func_190916_E();
                this.func_70299_a(slot, stack);
                if (stack.func_190916_E() < old) {
                    stack = stack.func_77946_l();
                    stack.func_190920_e(old - stack.func_190916_E());
                    continue;
                }
                return;
            }
            if (slotStack.func_77973_b() != stack.func_77973_b()) continue;
            old = slotStack.func_190916_E();
            slotStack.func_190917_f(stack.func_190916_E());
            if (slotStack.func_190916_E() > this.func_70297_j_()) {
                slotStack.func_190920_e(this.func_70297_j_());
            }
            stack.func_190918_g(slotStack.func_190916_E() - old);
            if (stack.func_190916_E() > 0) continue;
            return;
        }
        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)dump.func_177958_n(), (double)dump.func_177956_o(), (double)dump.func_177952_p(), (ItemStack)stack);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return ExplosionFurnaceManager.isValidExplosive(stack);
        }
        if (index == 1) {
            return ExplosionFurnaceManager.isValidDampener(stack);
        }
        if (index == 5) {
            return ExplosionFurnaceManager.isValidReagent(stack);
        }
        if (index >= 2 && index <= 4) {
            return ExplosionFurnaceManager.isValidInput(stack);
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.invHandler;
        }
        return (T)super.getCapability(capability, facing);
    }
}

