/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockEnergionCrystal;
import lykrast.prodigytech.common.block.BlockMachineActiveable;
import lykrast.prodigytech.common.init.ModBlocks;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.tileentity.TileHotAirMachine;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.IProdigyInventory;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileCrystalCutter
extends TileHotAirMachine {
    protected short clockTime;
    protected boolean processing;

    public TileCrystalCutter() {
        super(1, 0.8f);
        this.processTimeMax = Config.automaticCrystalCutterHarvestTime * 10;
        this.processing = false;
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "automatic_crystal_cutter";
    }

    protected BlockPos getTarget() {
        return this.field_174879_c.func_177972_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D));
    }

    public void func_73660_a() {
        boolean flag = this.processing;
        boolean flag1 = false;
        this.process();
        if (!this.field_145850_b.field_72995_K) {
            this.hotAir.updateInTemperature(this.field_145850_b, this.field_174879_c);
            if (this.canProcess()) {
                if (this.processing) {
                    BlockPos targetPos = this.getTarget();
                    IBlockState target = this.field_145850_b.func_180495_p(targetPos);
                    if (target.func_177230_c() == ModBlocks.energionCrystal && BlockEnergionCrystal.getAge(target) > 0) {
                        if (this.processTime <= 0) {
                            ItemStack stack = this.func_70301_a(0);
                            if (stack.func_190926_b()) {
                                this.func_70299_a(0, new ItemStack(ModItems.energionCrystalSeed));
                            } else {
                                stack.func_190917_f(1);
                            }
                            int age = BlockEnergionCrystal.getAge(target);
                            this.field_145850_b.func_175718_b(2001, targetPos, Block.func_176210_f((IBlockState)target));
                            this.field_145850_b.func_175656_a(targetPos, ((BlockEnergionCrystal)ModBlocks.energionCrystal).withAge(age - 1));
                            flag1 = true;
                            if (age <= 1) {
                                this.processing = false;
                            }
                            this.processTime = this.processTimeMax;
                        }
                    } else {
                        this.processing = false;
                        this.processTime = this.processTimeMax;
                    }
                } else if (this.clockTime <= 1) {
                    this.clockTime = (short)Config.automaticCrystalCutterIdleTime;
                    IBlockState target = this.field_145850_b.func_180495_p(this.getTarget());
                    if (target.func_177230_c() == ModBlocks.energionCrystal && BlockEnergionCrystal.getAge(target) >= 5) {
                        this.processing = true;
                        this.processTime = this.processTimeMax;
                    }
                } else {
                    this.clockTime = (short)(this.clockTime - 1);
                }
            } else {
                this.processing = false;
                this.processTime = this.processTimeMax;
            }
            this.hotAir.updateOutTemperature();
            if (flag != this.processing) {
                flag1 = true;
                BlockMachineActiveable.setState(this.processing, this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    @Override
    protected int getProcessSpeed() {
        return this.hotAir.getInAirTemperature() / 10;
    }

    @Override
    protected boolean canProcess() {
        ItemStack stack = this.func_70301_a(0);
        return this.hotAir.getInAirTemperature() >= 100 && (stack.func_190926_b() || stack.func_190916_E() < 64);
    }

    @Override
    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    protected IItemHandlerModifiable createInventoryHandler() {
        return new ProdigyInventoryHandler((IProdigyInventory)this, 1, 0, false, true);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.processTimeMax = Config.automaticCrystalCutterHarvestTime * 10;
        this.clockTime = compound.func_74765_d("ClockTime");
        this.processing = compound.func_74767_n("Processing");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("ClockTime", this.clockTime);
        compound.func_74757_a("Processing", this.processing);
        return compound;
    }
}

