/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockMachineActiveable;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirMachine;
import lykrast.prodigytech.common.item.IHeatCapacitor;
import lykrast.prodigytech.common.tileentity.IProcessing;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileCapacitorCharger
extends TileMachineInventory
implements ITickable,
IProcessing {
    private int progressCycle;
    private int targetTemperature;
    private HotAirMachine hotAir;
    private ProdigyInventoryHandler invHandler = new ProdigyInventoryHandler(this, 1, 0, true, true){

        @Override
        public boolean canExtract(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.func_190926_b()) {
                return true;
            }
            return super.canExtract(slot) && ((IHeatCapacitor)stack.func_77973_b()).isFullyCharged(stack);
        }
    };

    public TileCapacitorCharger() {
        super(1);
        this.hotAir = new HotAirMachine(this, 0.0f){

            @Override
            public int getOutAirTemperature() {
                return 0;
            }
        };
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "capacitor_charger";
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() instanceof IHeatCapacitor && ((IHeatCapacitor)stack.func_77973_b()).isChargeable(stack);
        }
        return false;
    }

    private boolean canProcess() {
        ItemStack capacitor = this.func_70301_a(0);
        if (capacitor.func_190926_b()) {
            return false;
        }
        IHeatCapacitor casted = (IHeatCapacitor)capacitor.func_77973_b();
        if (casted.isFullyCharged(capacitor)) {
            return false;
        }
        this.targetTemperature = casted.getTargetTemperature(capacitor);
        return this.hotAir.getInAirTemperature() >= this.targetTemperature;
    }

    public void func_73660_a() {
        boolean wasProcessing = this.isProcessing();
        boolean shouldDirty = false;
        this.process();
        if (!this.field_145850_b.field_72995_K) {
            this.hotAir.updateInTemperature(this.field_145850_b, this.field_174879_c);
            if (this.canProcess()) {
                if (this.progressCycle <= 0) {
                    this.progressCycle = 1;
                } else if (this.progressCycle > Config.capacitorChargerChargeTime * 10) {
                    ItemStack capacitor = this.func_70301_a(0);
                    ((IHeatCapacitor)capacitor.func_77973_b()).charge(capacitor, 20);
                    shouldDirty = true;
                    if (this.canProcess()) {
                        this.progressCycle = 1;
                    }
                }
            } else if (this.progressCycle > 0) {
                this.progressCycle = 0;
            }
            this.hotAir.updateOutTemperature();
            if (wasProcessing != this.isProcessing()) {
                shouldDirty = true;
                BlockMachineActiveable.setState(this.isProcessing(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (shouldDirty) {
            this.func_70296_d();
        }
    }

    private int getProcessSpeed() {
        if (this.targetTemperature <= 30) {
            return 10;
        }
        return 10 * this.hotAir.getInAirTemperature() / this.targetTemperature;
    }

    @Override
    public boolean isProcessing() {
        return this.progressCycle > 0;
    }

    @Override
    public int getProgressLeft() {
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b()) {
            return 0;
        }
        IHeatCapacitor capacitor = (IHeatCapacitor)stack.func_77973_b();
        return capacitor.getMaxCharge(stack) - capacitor.getChargeLeft(stack);
    }

    @Override
    public int getMaxProgress() {
        ItemStack stack = this.func_70301_a(0);
        return stack.func_190926_b() ? 0 : ((IHeatCapacitor)stack.func_77973_b()).getMaxCharge(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isProcessing(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    private void process() {
        if (this.isProcessing()) {
            this.progressCycle = this.canProcess() ? (this.progressCycle += this.getProcessSpeed()) : 0;
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.progressCycle;
            }
            case 1: {
                return this.targetTemperature;
            }
            case 2: {
                return this.hotAir.getInAirTemperature();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.progressCycle = value;
                break;
            }
            case 1: {
                this.targetTemperature = value;
                break;
            }
            case 2: {
                this.hotAir.setTemperature(value);
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 3;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.DOWN) {
            return true;
        }
        if (capability == CapabilityHotAir.HOT_AIR && facing == null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.DOWN) {
            return (T)this.invHandler;
        }
        if (capability == CapabilityHotAir.HOT_AIR && facing == null) {
            return (T)this.hotAir;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.progressCycle = compound.func_74762_e("ProgressCycle");
        this.targetTemperature = compound.func_74762_e("TargetTemperature");
        this.hotAir.deserializeNBT(compound.func_74775_l("HotAir"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("ProgressCycle", this.progressCycle);
        compound.func_74768_a("TargetTemperature", this.targetTemperature);
        compound.func_74782_a("HotAir", (NBTBase)this.hotAir.serializeNBT());
        return compound;
    }
}

