/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockMachineActiveable;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirMachine;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.AtomicReshaperManager;
import lykrast.prodigytech.common.tileentity.IProcessing;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.IProdigyInventory;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAtomicReshaper
extends TileMachineInventory
implements ITickable,
IProcessing {
    private int processTime;
    private int processTimeMax;
    private HotAirMachine hotAir;
    private int primordium;
    private AtomicReshaperManager.AtomicReshaperRecipe cachedRecipe;
    private ProdigyInventoryHandler invHandler = new ProdigyInventoryHandler((IProdigyInventory)this, 3, 0, new boolean[]{true, true, false}, new boolean[]{false, false, true});

    public TileAtomicReshaper() {
        super(3);
        this.hotAir = new HotAirMachine(this, 0.5f);
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "atomic_reshaper";
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() == ModItems.primordium;
        }
        if (index == 1) {
            return AtomicReshaperManager.INSTANCE.isValidInput(stack);
        }
        return false;
    }

    private int canSmeltPrimordium() {
        if (this.func_70301_a(0).func_190926_b() || this.primordium > (Config.atomicReshaperMaxPrimordium - 1) * 100) {
            return 0;
        }
        return 100;
    }

    private void updateCachedRecipe() {
        if (this.cachedRecipe == null) {
            this.cachedRecipe = (AtomicReshaperManager.AtomicReshaperRecipe)AtomicReshaperManager.INSTANCE.findRecipe(this.func_70301_a(1));
        } else if (!this.cachedRecipe.isValidInput(this.func_70301_a(1))) {
            this.cachedRecipe = (AtomicReshaperManager.AtomicReshaperRecipe)AtomicReshaperManager.INSTANCE.findRecipe(this.func_70301_a(1));
            this.processTimeMax = 0;
            this.processTime = 0;
        }
    }

    private boolean canProcess() {
        if (this.func_70301_a(1).func_190926_b() || this.hotAir.getInAirTemperature() < 250) {
            this.cachedRecipe = null;
            return false;
        }
        this.updateCachedRecipe();
        if (this.cachedRecipe == null) {
            return false;
        }
        if (this.cachedRecipe.getPrimordiumAmount() > this.primordium) {
            return false;
        }
        if (this.cachedRecipe.isSingleOutput()) {
            ItemStack itemstack = this.cachedRecipe.getSingleOutput();
            ItemStack itemstack1 = this.func_70301_a(2);
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(itemstack)) {
                return false;
            }
            if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
        }
        return this.func_70301_a(2).func_190926_b();
    }

    public void func_73660_a() {
        boolean flag = this.isProcessing();
        boolean flag1 = false;
        this.process();
        if (!this.field_145850_b.field_72995_K) {
            this.hotAir.updateInTemperature(this.field_145850_b, this.field_174879_c);
            int primordiumAmount = this.canSmeltPrimordium();
            if (primordiumAmount > 0) {
                this.primordium += primordiumAmount;
                this.func_70301_a(0).func_190918_g(1);
            }
            if (this.canProcess()) {
                if (this.processTimeMax <= 0) {
                    this.processTime = this.processTimeMax = this.cachedRecipe.getTimeProcessing();
                } else if (this.processTime <= 0) {
                    this.smelt();
                    flag1 = true;
                    if (this.canProcess()) {
                        this.processTime = this.processTimeMax = this.cachedRecipe.getTimeProcessing();
                    } else {
                        this.processTimeMax = 0;
                        this.processTime = 0;
                    }
                }
            } else if (this.processTime >= this.processTimeMax) {
                this.processTimeMax = 0;
                this.processTime = 0;
            }
            this.hotAir.updateOutTemperature();
            if (flag != this.isProcessing()) {
                flag1 = true;
                BlockMachineActiveable.setState(this.isProcessing(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private void smelt() {
        this.updateCachedRecipe();
        if (this.cachedRecipe.isSingleOutput()) {
            ItemStack itemstack1 = this.cachedRecipe.getSingleOutput();
            ItemStack itemstack2 = this.func_70301_a(2);
            if (itemstack2.func_190926_b()) {
                this.func_70299_a(2, itemstack1);
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
        } else {
            this.func_70299_a(2, this.cachedRecipe.getRandomOutput(this.field_145850_b.field_73012_v));
        }
        this.func_70301_a(1).func_190918_g(1);
        this.primordium -= this.cachedRecipe.getPrimordiumAmount();
    }

    private int getProcessSpeed() {
        return this.hotAir.getInAirTemperature() / 25;
    }

    @Override
    public boolean isProcessing() {
        return this.processTime > 0;
    }

    @Override
    public int getProgressLeft() {
        return this.processTime;
    }

    @Override
    public int getMaxProgress() {
        return this.processTimeMax;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isProcessing(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    private void process() {
        if (this.isProcessing()) {
            this.processTime = this.canProcess() ? (this.processTime -= this.getProcessSpeed()) : this.processTimeMax;
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.processTime;
            }
            case 1: {
                return this.processTimeMax;
            }
            case 2: {
                return this.hotAir.getInAirTemperature();
            }
            case 3: {
                return this.hotAir.getOutAirTemperature();
            }
            case 4: {
                return this.primordium;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.processTime = value;
                break;
            }
            case 1: {
                this.processTimeMax = value;
                break;
            }
            case 2: {
                this.hotAir.setTemperature(value);
                break;
            }
            case 3: {
                this.hotAir.setOutAirTemperature(value);
                break;
            }
            case 4: {
                this.primordium = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 5;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return true;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return (T)this.invHandler;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return (T)this.hotAir;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.processTime = compound.func_74762_e("ProcessTime");
        this.processTimeMax = compound.func_74762_e("ProcessTimeMax");
        this.hotAir.deserializeNBT(compound.func_74775_l("HotAir"));
        this.primordium = compound.func_74762_e("Primordium");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("ProcessTime", this.processTime);
        compound.func_74768_a("ProcessTimeMax", this.processTimeMax);
        compound.func_74782_a("HotAir", (NBTBase)this.hotAir.serializeNBT());
        compound.func_74768_a("Primordium", this.primordium);
        return compound;
    }
}

