/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import java.util.Arrays;
import lykrast.prodigytech.common.block.BlockHotAirMachine;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirAeroheater;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.IProdigyInventory;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAeroheaterTartaric
extends TileMachineInventory
implements ITickable {
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int stokerBurnTime;
    private HotAir hotAir;
    private ProdigyInventoryHandler invHandler = new ProdigyInventoryHandler((IProdigyInventory)this, 2, 0, true, false);

    public TileAeroheaterTartaric() {
        super(2);
        this.hotAir = new HotAir();
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "tartaric_aeroheater";
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0 && this.stokerBurnTime > 0;
    }

    public static boolean isBurningFuel(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public static boolean isBurningStoker(IInventory inventory) {
        return inventory.func_174887_a_(3) > 0;
    }

    public void func_73660_a() {
        boolean wasBurning = this.isBurning();
        boolean shouldDirty = false;
        if (this.furnaceBurnTime > 0) {
            this.furnaceBurnTime -= this.hotAir.getFuelSpeed();
            if (this.furnaceBurnTime < 0) {
                this.furnaceBurnTime = 0;
            }
        }
        if (this.stokerBurnTime > 0) {
            this.stokerBurnTime -= this.hotAir.getFuelSpeed();
            if (this.stokerBurnTime < 0) {
                this.stokerBurnTime = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isBurning() && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
                boolean shouldStoker;
                ItemStack fuel = this.func_70301_a(0);
                ItemStack stoker = this.func_70301_a(1);
                boolean canFuel = this.furnaceBurnTime == 0 && !fuel.func_190926_b();
                boolean canStoker = this.stokerBurnTime == 0 && !stoker.func_190926_b();
                boolean shouldFuel = canFuel && (this.stokerBurnTime > 0 || canStoker);
                boolean bl = shouldStoker = canStoker && (this.furnaceBurnTime > 0 || canFuel);
                if (shouldFuel) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                    shouldDirty = true;
                    Item item = fuel.func_77973_b();
                    fuel.func_190918_g(1);
                    if (fuel.func_190926_b()) {
                        ItemStack item1 = item.getContainerItem(fuel);
                        this.func_70299_a(0, item1);
                    }
                }
                if (shouldStoker) {
                    this.stokerBurnTime = Config.tartaricStokerTime;
                    shouldDirty = true;
                    stoker.func_190918_g(1);
                    if (stoker.func_190926_b()) {
                        this.func_70299_a(1, ItemStack.field_190927_a);
                    }
                }
            }
            if (this.isBurning()) {
                this.hotAir.raiseTemperature();
            } else {
                this.hotAir.lowerTemperature();
            }
            if (wasBurning != this.isBurning()) {
                shouldDirty = true;
                BlockHotAirMachine.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (shouldDirty) {
            this.func_70296_d();
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
        if (index == 1) {
            return stack.func_77973_b() == ModItems.tartaricStoker;
        }
        return false;
    }

    public boolean isBurningSomething() {
        return this.furnaceBurnTime > 0 || this.stokerBurnTime > 0;
    }

    public int getBurnLeft() {
        return this.furnaceBurnTime;
    }

    public int getBurnMax() {
        return this.currentItemBurnTime;
    }

    public int getStokerLeft() {
        return this.stokerBurnTime;
    }

    public int getStokerMax() {
        return Config.tartaricStokerTime;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.currentItemBurnTime = compound.func_74762_e("MaxBurnTime");
        this.stokerBurnTime = compound.func_74762_e("StokerTime");
        this.hotAir.deserializeNBT(compound.func_74775_l("HotAir"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.furnaceBurnTime);
        compound.func_74768_a("MaxBurnTime", this.currentItemBurnTime);
        compound.func_74768_a("StokerTime", this.stokerBurnTime);
        compound.func_74782_a("HotAir", (NBTBase)this.hotAir.serializeNBT());
        return compound;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.hotAir.getOutAirTemperature();
            }
            case 3: {
                return this.stokerBurnTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.hotAir.setTemperature(value);
                break;
            }
            case 3: {
                this.stokerBurnTime = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 4;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP) {
            return true;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP) {
            return (T)this.invHandler;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return (T)this.hotAir;
        }
        return (T)super.getCapability(capability, facing);
    }

    private static class HotAir
    extends HotAirAeroheater {
        private static final int[] THRESHOLDS = new int[]{80, 100, 125, 160, 200, 250, 320, 400, 500, 600, 750, 1000};
        private static final int[] SPEEDS = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 13, 16, 20, 25};
        private int index;

        public HotAir() {
            super(1000);
        }

        private int getFuelSpeed() {
            return SPEEDS[this.index];
        }

        private void updateIndex() {
            this.index = Arrays.binarySearch(THRESHOLDS, this.temperature);
            if (this.index < 0) {
                this.index = -(this.index + 1);
            }
            if (this.index >= THRESHOLDS.length) {
                this.index = THRESHOLDS.length - 1;
            }
        }

        @Override
        protected void resetRaiseClock() {
            this.temperatureClock = 2;
            this.updateIndex();
        }

        @Override
        protected void resetLowerClock() {
            this.temperatureClock = 1;
            this.updateIndex();
        }
    }
}

