/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockHotAirMachine;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirAeroheater;
import lykrast.prodigytech.common.tileentity.IProcessing;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import lykrast.prodigytech.common.util.IProdigyInventory;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAeroheaterSolid
extends TileMachineInventory
implements ITickable,
IProcessing {
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private HotAirAeroheater hotAir;
    private ProdigyInventoryHandler invHandler = new ProdigyInventoryHandler((IProdigyInventory)this, 1, 0, true, false);

    public TileAeroheaterSolid() {
        super(1);
        this.hotAir = new HotAir();
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "solid_fuel_aeroheater";
    }

    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean wasBurning = this.isProcessing();
        boolean shouldDirty = false;
        if (this.isProcessing()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuel = this.func_70301_a(0);
            if (!(this.isProcessing() || fuel.func_190926_b() || this.field_145850_b.func_175640_z(this.field_174879_c))) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                if (this.isProcessing()) {
                    shouldDirty = true;
                    if (!fuel.func_190926_b()) {
                        Item item = fuel.func_77973_b();
                        fuel.func_190918_g(1);
                        if (fuel.func_190926_b()) {
                            this.func_70299_a(0, item.getContainerItem(fuel));
                        }
                    }
                }
            }
            if (this.isProcessing()) {
                this.hotAir.raiseTemperature();
            } else {
                this.hotAir.lowerTemperature();
            }
            if (wasBurning != this.isProcessing()) {
                shouldDirty = true;
                BlockHotAirMachine.setState(this.isProcessing(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (shouldDirty) {
            this.func_70296_d();
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
        return false;
    }

    @Override
    public boolean isProcessing() {
        return this.furnaceBurnTime > 0;
    }

    @Override
    public int getProgressLeft() {
        return this.furnaceBurnTime;
    }

    @Override
    public int getMaxProgress() {
        return this.currentItemBurnTime;
    }

    @Override
    public boolean invertDisplay() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.currentItemBurnTime = compound.func_74762_e("MaxBurnTime");
        this.hotAir.deserializeNBT(compound.func_74775_l("HotAir"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.furnaceBurnTime);
        compound.func_74768_a("MaxBurnTime", this.currentItemBurnTime);
        compound.func_74782_a("HotAir", (NBTBase)this.hotAir.serializeNBT());
        return compound;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.hotAir.getOutAirTemperature();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.hotAir.setTemperature(value);
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 3;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP) {
            return true;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP) {
            return (T)this.invHandler;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return (T)this.hotAir;
        }
        return (T)super.getCapability(capability, facing);
    }

    private static class HotAir
    extends HotAirAeroheater {
        public HotAir() {
            super(200);
        }

        @Override
        protected void resetRaiseClock() {
            this.temperatureClock = this.temperature < 80 ? 2 : (this.temperature < 100 ? 10 : (this.temperature < 125 ? 24 : (this.temperature < 160 ? 40 : 60)));
        }

        @Override
        protected void resetLowerClock() {
            this.temperatureClock = this.temperature > 160 ? 2 : (this.temperature > 125 ? 4 : (this.temperature > 100 ? 8 : (this.temperature > 80 ? 15 : 20)));
        }
    }
}

