/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.tileentity;

import lykrast.prodigytech.common.block.BlockHotAirMachine;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirChangeable;
import lykrast.prodigytech.common.item.IHeatCapacitor;
import lykrast.prodigytech.common.tileentity.IProcessing;
import lykrast.prodigytech.common.tileentity.TileMachineInventory;
import lykrast.prodigytech.common.util.ProdigyInventoryHandler;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAeroheaterCapacitor
extends TileMachineInventory
implements ITickable,
IProcessing {
    private int targetTemperature;
    private boolean active;
    private HotAir hotAir;
    private ProdigyInventoryHandler invHandler = new ProdigyInventoryHandler(this, 1, 0, true, true){

        @Override
        public boolean canExtract(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.func_190926_b()) {
                return true;
            }
            return super.canExtract(slot) && ((IHeatCapacitor)stack.func_77973_b()).isDepleted(stack);
        }
    };

    public TileAeroheaterCapacitor() {
        super(1);
        this.hotAir = new HotAir();
    }

    @Override
    public String func_70005_c_() {
        return super.func_70005_c_() + "capacitor_aeroheater";
    }

    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean wasActive = this.active;
        boolean shouldDirty = false;
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuel = this.func_70301_a(0);
            if (!fuel.func_190926_b() && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
                IHeatCapacitor capacitor = (IHeatCapacitor)fuel.func_77973_b();
                if (!capacitor.isDepleted(fuel)) {
                    this.targetTemperature = capacitor.getTargetTemperature(fuel);
                    capacitor.discharge(fuel, 1);
                    this.active = true;
                    shouldDirty = true;
                } else {
                    this.active = false;
                }
            } else {
                this.active = false;
            }
            if (this.active) {
                this.hotAir.raiseTemperature(this.targetTemperature);
            } else {
                this.hotAir.lowerTemperature();
            }
            if (wasActive != this.active) {
                shouldDirty = true;
                BlockHotAirMachine.setState(this.active, this.field_145850_b, this.field_174879_c);
            }
        }
        if (shouldDirty) {
            this.func_70296_d();
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() instanceof IHeatCapacitor;
        }
        return false;
    }

    @Override
    public boolean isProcessing() {
        return this.active;
    }

    @Override
    public int getProgressLeft() {
        ItemStack stack = this.func_70301_a(0);
        return stack.func_190926_b() ? 0 : ((IHeatCapacitor)stack.func_77973_b()).getChargeLeft(stack);
    }

    @Override
    public int getMaxProgress() {
        ItemStack stack = this.func_70301_a(0);
        return stack.func_190926_b() ? 0 : ((IHeatCapacitor)stack.func_77973_b()).getMaxCharge(stack);
    }

    @Override
    public boolean invertDisplay() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.active = compound.func_74767_n("Active");
        this.targetTemperature = compound.func_74762_e("TargetTemperature");
        this.hotAir.deserializeNBT(compound.func_74775_l("HotAir"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Active", this.active);
        compound.func_74768_a("TargetTemperature", this.targetTemperature);
        compound.func_74782_a("HotAir", (NBTBase)this.hotAir.serializeNBT());
        return compound;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.active ? 1 : 0;
            }
            case 1: {
                return this.targetTemperature;
            }
            case 2: {
                return this.hotAir.getOutAirTemperature();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.active = value != 0;
                break;
            }
            case 1: {
                this.targetTemperature = value;
                break;
            }
            case 2: {
                this.hotAir.setTemperature(value);
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 3;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP) {
            return true;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP) {
            return (T)this.invHandler;
        }
        if (capability == CapabilityHotAir.HOT_AIR && (facing == EnumFacing.UP || facing == null)) {
            return (T)this.hotAir;
        }
        return (T)super.getCapability(capability, facing);
    }

    private static class HotAir
    extends HotAirChangeable {
        private HotAir() {
        }

        public void raiseTemperature(int target) {
            this.temperature = this.temperature > target ? Math.max(target, this.temperature - 10) : Math.min(target, this.temperature + 10);
        }

        public void lowerTemperature() {
            this.temperature = Math.max(30, this.temperature - 10);
        }
    }
}

