/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ZorraAltarManager {
    public static final ZorraAltarManager SWORD = new ZorraAltarManager();
    public static final ZorraAltarManager BOW = new ZorraAltarManager();
    private List<EnchantmentData> enchants = new ArrayList<EnchantmentData>();

    public static void init() {
        Enchantment soulbound;
        SWORD.addEnchantBonusLevel(Enchantments.field_185302_k, Config.altarBonusLvl);
        SWORD.addEnchantBonusLevel(Enchantments.field_185303_l, Config.altarBonusLvl);
        SWORD.addEnchantBonusLevel(Enchantments.field_180312_n, Config.altarBonusLvl);
        SWORD.addEnchantBonusLevel(Enchantments.field_77334_n, Config.altarBonusLvl);
        SWORD.addEnchantBonusLevel(Enchantments.field_180313_o, Config.altarBonusLvl);
        SWORD.addEnchantBonusLevel(Enchantments.field_185304_p, Config.altarBonusLvl);
        SWORD.addEnchantBonusLevel(Enchantments.field_191530_r, Config.altarBonusLvl);
        BOW.addEnchantBonusLevel(Enchantments.field_185309_u, Config.altarBonusLvl);
        BOW.addEnchantBonusLevel(Enchantments.field_185310_v, Config.altarBonusLvl);
        BOW.addEnchant(Enchantments.field_185311_w, 1);
        BOW.addEnchant(Enchantments.field_185312_x, 1);
        ItemStack checkerSword = new ItemStack(Items.field_151040_l);
        ItemStack checkerBow = new ItemStack((Item)Items.field_151031_f);
        boolean hasSoulbound = false;
        if (Loader.isModLoaded((String)"endercore")) {
            SWORD.addModdedEnchantBonusLevel("endercore:xpboost", Config.altarBonusLvl, checkerSword);
            BOW.addModdedEnchantBonusLevel("endercore:xpboost", Config.altarBonusLvl, checkerBow);
        }
        if (Loader.isModLoaded((String)"enderio")) {
            SWORD.addModdedEnchant("enderio:witherweapon", 1, checkerSword);
            BOW.addModdedEnchant("enderio:witherarrow", 1, checkerBow);
            soulbound = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("enderio:soulbound"));
            if (!hasSoulbound && soulbound != null && (soulbound.func_92089_a(checkerSword) || soulbound.func_92089_a(checkerBow))) {
                hasSoulbound = true;
                SWORD.addEnchant(soulbound, 1);
                BOW.addEnchant(soulbound, 1);
            }
        }
        if (Loader.isModLoaded((String)"cofhcore")) {
            SWORD.addModdedEnchantBonusLevel("cofhcore:insight", Config.altarBonusLvl, checkerSword);
            SWORD.addModdedEnchantBonusLevel("cofhcore:leech", Config.altarBonusLvl, checkerSword);
            SWORD.addModdedEnchantBonusLevel("cofhcore:vorpal", Config.altarBonusLvl, checkerSword);
            BOW.addModdedEnchantBonusLevel("cofhcore:insight", Config.altarBonusLvl, checkerBow);
            soulbound = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("cofhcore:soulbound"));
            if (!hasSoulbound && soulbound != null && (soulbound.func_92089_a(checkerSword) || soulbound.func_92089_a(checkerBow))) {
                hasSoulbound = true;
                if (soulbound.func_77325_b() == 1) {
                    SWORD.addEnchant(soulbound, 1);
                    BOW.addEnchant(soulbound, 1);
                } else {
                    SWORD.addEnchantBonusLevel(soulbound, Config.altarBonusLvl);
                    BOW.addEnchantBonusLevel(soulbound, Config.altarBonusLvl);
                }
            }
        }
        if (Loader.isModLoaded((String)"cyclicmagic")) {
            SWORD.addModdedEnchant("cyclicmagic:enchantment.beheading", 1, checkerSword);
            SWORD.addModdedEnchantBonusLevel("cyclicmagic:enchantment.lifeleech", Config.altarBonusLvl, checkerSword);
            SWORD.addModdedEnchantBonusLevel("cyclicmagic:enchantment.venom", Config.altarBonusLvl, checkerSword);
            BOW.addModdedEnchant("cyclicmagic:enchantment.quickdraw", 1, checkerBow);
        }
        if (Loader.isModLoaded((String)"draconicevolution")) {
            SWORD.addModdedEnchantBonusLevel("draconicevolution:enchant_reaper", Config.altarBonusLvl, checkerSword);
        }
        if (Loader.isModLoaded((String)"abyssalcraft")) {
            SWORD.addModdedEnchantBonusLevel("abyssalcraft:light_pierce", Config.altarBonusLvl, checkerSword);
        }
        if (Loader.isModLoaded((String)"soulshardsrespawn")) {
            SWORD.addModdedEnchantBonusLevel("soulshardsrespawn:soul_stealer", Config.altarBonusLvl, checkerSword);
        }
        if (Loader.isModLoaded((String)"evilcraft")) {
            SWORD.addModdedEnchantBonusLevel("evilcraft:life_stealing", Config.altarBonusLvl, checkerSword);
            BOW.addModdedEnchantBonusLevel("evilcraft:poison_tip", Config.altarBonusLvl, checkerBow);
        }
        if (Loader.isModLoaded((String)"woot")) {
            SWORD.addModdedEnchantBonusLevel("woot:headhunter", 0, checkerSword);
        }
        if (Loader.isModLoaded((String)"apotheosis")) {
            SWORD.addModdedEnchantBonusLevel("apotheosis:hell_infusion", Config.altarBonusLvl, checkerSword);
            SWORD.addModdedEnchantBonusLevel("apotheosis:mounted_strike", Config.altarBonusLvl, checkerSword);
            SWORD.addModdedEnchantBonusLevel("apotheosis:scavenger", Config.altarBonusLvl, checkerSword);
            SWORD.addModdedEnchantBonusLevel("apotheosis:capturing", Config.altarBonusLvl, checkerSword);
            if (BOW.addModdedEnchantBonusLevel("apotheosis:true_infinity", 0, checkerBow)) {
                BOW.removeEnchant(Enchantments.field_185312_x);
            }
        }
    }

    public void addEnchant(EnchantmentData enchant) {
        this.enchants.add(enchant);
    }

    public void addEnchant(Enchantment enchant, int maxLvl) {
        this.enchants.add(new EnchantmentData(enchant, maxLvl));
    }

    public void addEnchantBonusLevel(Enchantment enchant, int bonusLvl) {
        this.enchants.add(new EnchantmentData(enchant, enchant.func_77325_b() + bonusLvl));
    }

    public boolean addModdedEnchant(String key, int maxLvl, ItemStack checker) {
        Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(key));
        if (enchant == null || !enchant.func_92089_a(checker)) {
            return false;
        }
        this.addEnchant(enchant, maxLvl);
        return true;
    }

    public boolean addModdedEnchantBonusLevel(String key, int bonusLvl, ItemStack checker) {
        Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(key));
        if (enchant == null || !enchant.func_92089_a(checker)) {
            return false;
        }
        this.addEnchantBonusLevel(enchant, bonusLvl);
        return true;
    }

    public boolean removeEnchant(Enchantment enchant) {
        for (int i = 0; i < this.enchants.size(); ++i) {
            if (this.enchants.get((int)i).field_76302_b != enchant) continue;
            this.enchants.remove(i);
            return true;
        }
        return false;
    }

    public int getLevelCost(EnchantmentData data) {
        int lvl = data.field_76303_c;
        int cost = lvl <= 1 ? data.field_76302_b.func_77321_a(1) : data.field_76302_b.func_77321_a(lvl) - data.field_76302_b.func_77321_a(lvl - 1) / 2;
        return Math.max(1, (int)((float)cost * Config.altarCostMult));
    }

    public int deviate(int cost, Random rand) {
        int deviation = Math.max(2, (int)((double)cost * 0.1));
        return Math.max(1, cost - deviation + rand.nextInt(deviation * 2 + 1));
    }

    public int getRandomLevelCost(EnchantmentData data, Random rand) {
        return this.deviate(this.getLevelCost(data), rand);
    }

    public List<EnchantmentData> getAvailableEnchants(ItemStack stack) {
        ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>();
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (EnchantmentData data : this.enchants) {
            Integer lvl = (Integer)map.get(data.field_76302_b);
            if (lvl == null) {
                list.add(new EnchantmentData(data.field_76302_b, 1));
                continue;
            }
            if (lvl >= data.field_76303_c) continue;
            list.add(new EnchantmentData(data.field_76302_b, lvl + 1));
        }
        return list;
    }

    public EnchantmentData[] getRandomEnchants(ItemStack stack, Random rand) {
        ArrayList<Object> apply = new ArrayList<Object>();
        ArrayList<EnchantmentData> upgrade = new ArrayList<EnchantmentData>();
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (EnchantmentData data : this.enchants) {
            Integer lvl = (Integer)map.get(data.field_76302_b);
            if (lvl == null) {
                apply.add(new EnchantmentData(data.field_76302_b, 1));
                continue;
            }
            if (lvl >= data.field_76303_c) continue;
            upgrade.add(new EnchantmentData(data.field_76302_b, lvl + 1));
        }
        EnchantmentData[] datas = new EnchantmentData[3];
        if (!apply.isEmpty() || !upgrade.isEmpty()) {
            int i;
            if (!apply.isEmpty()) {
                i = rand.nextInt(apply.size());
                datas[0] = (EnchantmentData)apply.remove(i);
            } else {
                i = rand.nextInt(upgrade.size());
                datas[0] = (EnchantmentData)upgrade.remove(i);
            }
            if (!upgrade.isEmpty()) {
                i = rand.nextInt(upgrade.size());
                datas[1] = (EnchantmentData)upgrade.remove(i);
            } else if (!apply.isEmpty()) {
                i = rand.nextInt(apply.size());
                datas[1] = (EnchantmentData)apply.remove(i);
            }
            apply.addAll(upgrade);
            if (!apply.isEmpty()) {
                i = rand.nextInt(apply.size());
                datas[2] = (EnchantmentData)apply.remove(i);
            }
        }
        return datas;
    }
}

