/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import java.util.ArrayList;
import java.util.List;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SoldererManager {
    public static final List<SoldererRecipe> RECIPES = new ArrayList<SoldererRecipe>();
    private static int idGoldDust;
    private static int idGoldTinyDust;

    public static SoldererRecipe addRecipe(ItemStack pattern, ItemStack additive, ItemStack output, int gold) {
        return SoldererManager.addRecipe(new SoldererRecipe(pattern, additive, output, gold));
    }

    public static SoldererRecipe addRecipe(ItemStack pattern, ItemStack additive, ItemStack output, int gold, int time) {
        return SoldererManager.addRecipe(new SoldererRecipe(pattern, additive, output, gold, time));
    }

    public static SoldererRecipe addRecipe(SoldererRecipe recipe) {
        RECIPES.add(recipe);
        return recipe;
    }

    public static void removeAll() {
        RECIPES.clear();
    }

    public static SoldererRecipe findRecipe(ItemStack pattern, ItemStack additive, int gold) {
        for (SoldererRecipe recipe : RECIPES) {
            if (!recipe.isValidInput(pattern, additive, gold)) continue;
            return recipe;
        }
        return null;
    }

    public static SoldererRecipe removeRecipe(ItemStack pattern, ItemStack additive, int gold) {
        SoldererRecipe recipe = SoldererManager.findRecipe(pattern, additive, gold);
        if (recipe != null) {
            RECIPES.remove(recipe);
        }
        return recipe;
    }

    public static boolean isValidPattern(ItemStack pattern) {
        for (SoldererRecipe recipe : RECIPES) {
            if (!recipe.isValidPattern(pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidAdditive(ItemStack additive) {
        for (SoldererRecipe recipe : RECIPES) {
            if (!recipe.requiresAdditive() || !recipe.isValidAdditive(additive)) continue;
            return true;
        }
        return false;
    }

    public static int getGoldAmount(ItemStack stack) {
        int[] oreIDs;
        if (stack.func_190926_b()) {
            return 0;
        }
        for (int i : oreIDs = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (i == idGoldDust) {
                return 9;
            }
            if (i != idGoldTinyDust) continue;
            return 1;
        }
        return 0;
    }

    public static boolean isPlate(ItemStack stack) {
        return stack.func_77973_b() == ModItems.circuitPlate;
    }

    public static void init() {
        idGoldDust = OreDictionary.getOreID((String)"dustGold");
        idGoldTinyDust = OreDictionary.getOreID((String)"dustTinyGold");
        SoldererManager.addRecipe(new ItemStack(ModItems.patternCircuitCrude), ItemStack.field_190927_a, new ItemStack(ModItems.circuitCrude), 3);
        SoldererManager.addRecipe(new ItemStack(ModItems.patternCircuitRefined), new ItemStack(Items.field_151042_j), new ItemStack(ModItems.circuitRefined), 6, (int)((double)Config.soldererProcessTime * 1.5));
        SoldererManager.addRecipe(new ItemStack(ModItems.patternCircuitPerfected), new ItemStack(Items.field_151045_i), new ItemStack(ModItems.circuitPerfected), 9, Config.soldererProcessTime * 2);
    }

    public static class SoldererRecipe {
        private final ItemStack pattern;
        private final ItemStack additive;
        private final ItemStack output;
        private final int time;
        private final int gold;

        public SoldererRecipe(ItemStack pattern, ItemStack additive, ItemStack output, int gold) {
            this(pattern, additive, output, gold, Config.soldererProcessTime);
        }

        public SoldererRecipe(ItemStack pattern, ItemStack additive, ItemStack output, int gold, int time) {
            this.pattern = pattern;
            pattern.func_190920_e(1);
            this.additive = additive;
            this.output = output;
            this.gold = gold;
            this.time = time;
        }

        public ItemStack getPattern() {
            return this.pattern.func_77946_l();
        }

        public ItemStack getAdditive() {
            return this.additive.func_77946_l();
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public int getGoldAmount() {
            return this.gold;
        }

        public int getTimeTicks() {
            return this.time;
        }

        public int getTimeProcessing() {
            return this.time * 10;
        }

        public boolean isValidInput(ItemStack pattern, ItemStack additive, int gold) {
            if (!this.isValidPattern(pattern)) {
                return false;
            }
            if (!this.isValidAdditive(additive)) {
                return false;
            }
            return this.isEnoughGold(gold);
        }

        public boolean isValidPattern(ItemStack pattern) {
            return pattern.func_77969_a(this.pattern);
        }

        public boolean requiresAdditive() {
            return !this.additive.func_190926_b();
        }

        public boolean isValidAdditive(ItemStack additive) {
            if (!this.requiresAdditive()) {
                return true;
            }
            return additive.func_77969_a(this.additive) && additive.func_190916_E() >= this.additive.func_190916_E();
        }

        public boolean isEnoughGold(int gold) {
            return gold >= this.gold;
        }
    }
}

