/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import java.util.List;
import javax.annotation.Nullable;
import lykrast.prodigytech.common.recipe.ISingleInputRecipe;
import lykrast.prodigytech.common.recipe.ItemMap;
import net.minecraft.item.ItemStack;

public abstract class SimpleRecipeManagerAbstract<T extends ISingleInputRecipe> {
    protected final ItemMap<T> recipes = new ItemMap();

    protected SimpleRecipeManagerAbstract() {
    }

    public List<T> getAllRecipes() {
        return this.recipes.getAllContent();
    }

    public T addRecipe(T recipe) {
        if (recipe.isOreRecipe()) {
            this.recipes.add(recipe.getOreInput(), recipe);
        } else {
            this.recipes.add(recipe.getInput(), recipe);
        }
        return recipe;
    }

    @Nullable
    public T findRecipe(ItemStack in) {
        return (T)((ISingleInputRecipe)this.recipes.find(in));
    }

    @Nullable
    public T removeRecipe(ItemStack in) {
        return (T)((ISingleInputRecipe)this.recipes.remove(in));
    }

    @Nullable
    public T removeOreRecipe(String in) {
        return (T)((ISingleInputRecipe)this.recipes.remove(in));
    }

    public void removeAll() {
        this.recipes.clear();
    }

    public boolean isValidInput(ItemStack check) {
        return this.recipes.isValid(check);
    }

    public abstract void init();
}

