/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import lykrast.prodigytech.common.recipe.ISingleInputRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SimpleRecipe
implements ISingleInputRecipe,
Comparable<SimpleRecipe> {
    private static int NEXTID = 0;
    private int id;
    protected final ItemStack input;
    protected final ItemStack output;
    protected final int time;
    protected final String oreInput;

    public SimpleRecipe(ItemStack input, ItemStack output, int time) {
        this.input = input;
        input.func_190920_e(1);
        this.output = output;
        this.time = time;
        this.oreInput = null;
        this.id = NEXTID++;
    }

    public SimpleRecipe(String inputOre, ItemStack output, int time) {
        this.oreInput = inputOre;
        this.input = ItemStack.field_190927_a;
        this.output = output;
        this.time = time;
        this.id = NEXTID++;
    }

    @Override
    public boolean isOreRecipe() {
        return this.oreInput != null && this.input.func_190926_b();
    }

    @Override
    public ItemStack getInput() {
        return this.input.func_77946_l();
    }

    @Override
    public String getOreInput() {
        return this.oreInput;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public int getTimeTicks() {
        return this.time;
    }

    public int getTimeProcessing() {
        return this.time * 10;
    }

    @Override
    public boolean isValidInput(ItemStack in) {
        if (in.func_190926_b()) {
            return false;
        }
        if (this.oreInput != null) {
            int[] oreIDs;
            for (int i : oreIDs = OreDictionary.getOreIDs((ItemStack)in)) {
                if (!OreDictionary.getOreName((int)i).equals(this.oreInput)) continue;
                return true;
            }
            return false;
        }
        return in.func_77969_a(this.input) && in.func_190916_E() >= this.input.func_190916_E();
    }

    @Override
    public int compareTo(SimpleRecipe other) {
        return Integer.compareUnsigned(this.id, other.id);
    }
}

