/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import lykrast.prodigytech.common.init.ModBlocks;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.SimpleRecipe;
import lykrast.prodigytech.common.recipe.SimpleRecipeManager;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.RecipeUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class RotaryGrinderManager
extends SimpleRecipeManager {
    public static final RotaryGrinderManager INSTANCE = new RotaryGrinderManager();

    public SimpleRecipe addRecipe(ItemStack in, ItemStack out) {
        return this.addRecipe(in, out, Config.rotaryGrinderProcessTime);
    }

    public SimpleRecipe addRecipe(String inOre, ItemStack out) {
        return this.addRecipe(inOre, out, Config.rotaryGrinderProcessTime);
    }

    @Override
    public void init() {
        this.addRecipe("logWood", new ItemStack(ModItems.sawdust, 4));
        this.addRecipe("plankWood", new ItemStack(ModItems.sawdust));
        this.addRecipe(new ItemStack(Blocks.field_150417_aV, 1, BlockStoneBrick.field_176248_b), new ItemStack(Blocks.field_150417_aV, 1, BlockStoneBrick.field_176251_N));
        this.addRecipe(new ItemStack(Blocks.field_150417_aV, 1, BlockStoneBrick.field_176252_O), new ItemStack(Blocks.field_150417_aV, 1, BlockStoneBrick.field_176251_N));
        this.addRecipe(new ItemStack(Blocks.field_150417_aV, 1, BlockStoneBrick.field_176251_N), new ItemStack(Blocks.field_150347_e));
        this.addRecipe("stone", new ItemStack(Blocks.field_150347_e));
        this.addRecipe("cobblestone", new ItemStack(Blocks.field_150351_n));
        this.addRecipe("gravel", new ItemStack((Block)Blocks.field_150354_m));
        if (RecipeUtil.oreExists("dust")) {
            this.addRecipe("sand", RecipeUtil.getPreferredOreStack("dust"));
        }
        if (RecipeUtil.itemExists("exnihilocreatio:block_netherrack_crushed")) {
            this.addRecipe("netherrack", new ItemStack(RecipeUtil.getExteriorItem("exnihilocreatio:block_netherrack_crushed")));
        }
        if (RecipeUtil.itemExists("exnihilocreatio:block_endstone_crushed")) {
            this.addRecipe("endstone", new ItemStack(RecipeUtil.getExteriorItem("exnihilocreatio:block_endstone_crushed")));
        }
        if (RecipeUtil.oreExists("crushedGranite")) {
            this.addRecipe("stoneGranite", RecipeUtil.getPreferredOreStack("crushedGranite"));
        }
        if (RecipeUtil.oreExists("crushedDiorite")) {
            this.addRecipe("stoneDiorite", RecipeUtil.getPreferredOreStack("crushedDiorite"));
        }
        if (RecipeUtil.oreExists("crushedAndesite")) {
            this.addRecipe("stoneAndesite", RecipeUtil.getPreferredOreStack("crushedAndesite"));
        }
        this.addRecipe(new ItemStack(ModBlocks.charredStoneBricks), new ItemStack(ModBlocks.charredCobblestone));
        this.addRecipe("stoneCharred", new ItemStack(ModBlocks.charredCobblestone));
        this.addRecipe("cobblestoneCharred", new ItemStack(Blocks.field_150351_n));
        this.addRecipe(new ItemStack(Blocks.field_150322_A, 1, Short.MAX_VALUE), new ItemStack((Block)Blocks.field_150354_m, 2));
        this.addRecipe(new ItemStack(Blocks.field_180395_cM, 1, Short.MAX_VALUE), new ItemStack((Block)Blocks.field_150354_m, 2, 1));
        this.addRecipe(new ItemStack(Blocks.field_150426_aN), new ItemStack(Items.field_151114_aO, 4));
        this.addRecipe(new ItemStack(Blocks.field_150435_aG), new ItemStack(Items.field_151119_aD, 4), Config.rotaryGrinderProcessTime / 8);
        this.addRecipe(new ItemStack(Blocks.field_150336_V), new ItemStack(Items.field_151118_aC, 4));
        this.addRecipe(new ItemStack(Blocks.field_150385_bj), new ItemStack(Items.field_151130_bT, 4));
        this.addRecipe(new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176331_b), new ItemStack(Items.field_179562_cC, 4));
        this.addRecipe(new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176333_M), new ItemStack(Items.field_179562_cC, 9));
        this.addRecipe(new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176334_N), new ItemStack(Items.field_179562_cC, 8));
        this.addRecipe(new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151065_br, 4));
        this.addRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 6, 15));
        this.addRecipe("cropWheat", new ItemStack(ModItems.flour));
        this.addRecipe(new ItemStack(Items.field_151147_al), new ItemStack(ModItems.meatGround, 2));
        this.addRecipe(new ItemStack(Items.field_151082_bd), new ItemStack(ModItems.meatGround, 2));
        this.addRecipe(new ItemStack(Items.field_151076_bf), new ItemStack(ModItems.meatGround, 2));
        this.addRecipe(new ItemStack(Items.field_179558_bo), new ItemStack(ModItems.meatGround));
        this.addRecipe(new ItemStack(Items.field_179561_bm), new ItemStack(ModItems.meatGround, 2));
        this.addRecipe("oreCoal", new ItemStack(ModItems.coalDust, Config.rotaryGrinderOreMultiplier));
        if (!Config.autoOreRecipes) {
            this.addRecipe("oreIron", new ItemStack(ModItems.ironDust, Config.rotaryGrinderOreMultiplier));
        }
        if (!Config.autoOreRecipes) {
            this.addRecipe("oreGold", new ItemStack(ModItems.goldDust, Config.rotaryGrinderOreMultiplier));
        }
        this.addRecipe("oreLapis", new ItemStack(Items.field_151100_aR, 6 * Config.rotaryGrinderOreMultiplier, 4));
        this.addRecipe("oreRedstone", new ItemStack(Items.field_151137_ax, (int)(4.5 * (double)Config.rotaryGrinderOreMultiplier)));
        if (!Config.autoOreRecipes) {
            this.addRecipe("oreDiamond", new ItemStack(ModItems.diamondDust, Config.rotaryGrinderOreMultiplier));
        }
        if (!Config.autoOreRecipes) {
            this.addRecipe("oreEmerald", new ItemStack(ModItems.emeraldDust, Config.rotaryGrinderOreMultiplier));
        }
        this.addRecipe("oreQuartz", new ItemStack(ModItems.quartzDust, Config.rotaryGrinderOreMultiplier));
        this.addRecipe(new ItemStack(Items.field_151044_h), new ItemStack(ModItems.coalDust));
        this.addRecipe("blockCoal", new ItemStack(ModItems.coalDust, 9), Config.rotaryGrinderProcessTime * 9);
        this.addRecipe("plateCarbon", new ItemStack(ModItems.coalDust, 8));
        if (!Config.autoOreRecipes) {
            this.addRecipe("ingotIron", new ItemStack(ModItems.ironDust));
            this.addRecipe("blockIron", new ItemStack(ModItems.ironDust, 9), Config.rotaryGrinderProcessTime * 9);
            this.addRecipe("nuggetIron", new ItemStack(ModItems.ironDustTiny), Config.rotaryGrinderProcessTime / 9);
            this.addRecipe("ingotGold", new ItemStack(ModItems.goldDust));
            this.addRecipe("blockGold", new ItemStack(ModItems.goldDust, 9), Config.rotaryGrinderProcessTime * 9);
            this.addRecipe("nuggetGold", new ItemStack(ModItems.goldDustTiny), Config.rotaryGrinderProcessTime / 9);
            this.addRecipe("gemDiamond", new ItemStack(ModItems.diamondDust));
            this.addRecipe("blockDiamond", new ItemStack(ModItems.diamondDust, 9), Config.rotaryGrinderProcessTime * 9);
            this.addRecipe("gemEmerald", new ItemStack(ModItems.emeraldDust));
            this.addRecipe("blockEmerald", new ItemStack(ModItems.emeraldDust, 9), Config.rotaryGrinderProcessTime * 9);
        }
        this.addRecipe("gemQuartz", new ItemStack(ModItems.quartzDust));
        this.addRecipe("blockQuartz", new ItemStack(ModItems.quartzDust, 4), Config.rotaryGrinderProcessTime * 4);
        this.addRecipe(new ItemStack(Blocks.field_150370_cb), new ItemStack(ModItems.quartzDust, 6), Config.rotaryGrinderProcessTime * 6);
        this.addRecipe(new ItemStack((Block)Blocks.field_150333_U, 1, Blocks.field_150333_U.func_176201_c(Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.QUARTZ))), new ItemStack(ModItems.quartzDust, 2), Config.rotaryGrinderProcessTime * 2);
        this.addRecipe("ingotFerramic", new ItemStack(ModItems.ferramicDust));
        this.addRecipe("blockFerramic", new ItemStack(ModItems.ferramicDust, 9), Config.rotaryGrinderProcessTime * 9);
        this.addRecipe("nuggetFerramic", new ItemStack(ModItems.ferramicDustTiny), Config.rotaryGrinderProcessTime / 9);
        this.addRecipe("gearFerramic", new ItemStack(ModItems.ferramicDustTiny, 32));
        this.addRecipe("gemEnergion", new ItemStack(ModItems.energionDust));
        this.addRecipe(new ItemStack(ModItems.infernoCrystal), new ItemStack(ModItems.infernoFuel));
    }
}

