/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lykrast.prodigytech.common.util.RecipeUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class PrimordialisReactorManager {
    private static Set<Pair<Item, Integer>> inputs = new HashSet<Pair<Item, Integer>>();
    private static Set<String> inputsOre = new HashSet<String>();

    private PrimordialisReactorManager() {
    }

    public static void addInput(Item item) {
        inputs.add(RecipeUtil.stackToPair(new ItemStack(item)));
    }

    public static void addInput(Block block) {
        inputs.add(RecipeUtil.stackToPair(new ItemStack(block)));
    }

    public static void addInput(ItemStack stack) {
        inputs.add(RecipeUtil.stackToPair(stack));
    }

    public static void addInput(String ore) {
        inputsOre.add(ore);
    }

    public static void removeInput(ItemStack stack) {
        inputs.remove(RecipeUtil.stackToPair(stack));
    }

    public static void removeInput(String ore) {
        inputsOre.remove(ore);
    }

    public static void removeAll() {
        inputs.clear();
        inputsOre.clear();
    }

    public static boolean isValidInput(ItemStack in) {
        int[] ores;
        if (in.func_190926_b()) {
            return false;
        }
        if (inputs.contains(RecipeUtil.stackToPair(in)) || inputs.contains(RecipeUtil.stackToWildcardPair(in))) {
            return true;
        }
        for (int i : ores = OreDictionary.getOreIDs((ItemStack)in)) {
            if (!inputsOre.contains(OreDictionary.getOreName((int)i))) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getAllEntries() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        inputs.forEach(pair -> list.add(RecipeUtil.pairToStack((Pair<Item, Integer>)pair)));
        return list;
    }

    public static List<String> getAllOreEntries() {
        ArrayList<String> list = new ArrayList<String>(inputsOre);
        return list;
    }

    public static void init() {
        PrimordialisReactorManager.addInput("treeSapling");
        PrimordialisReactorManager.addInput(Items.field_151034_e);
        PrimordialisReactorManager.addInput("vine");
        PrimordialisReactorManager.addInput((Block)Blocks.field_150337_Q);
        PrimordialisReactorManager.addInput((Block)Blocks.field_150338_P);
        PrimordialisReactorManager.addInput("cropWheat");
        PrimordialisReactorManager.addInput(Items.field_151014_N);
        PrimordialisReactorManager.addInput("cropPotato");
        PrimordialisReactorManager.addInput("cropCarrot");
        PrimordialisReactorManager.addInput(Items.field_185164_cV);
        PrimordialisReactorManager.addInput(Items.field_185163_cU);
        PrimordialisReactorManager.addInput("cropNetherWart");
        PrimordialisReactorManager.addInput("sugarcane");
        PrimordialisReactorManager.addInput("blockCactus");
        PrimordialisReactorManager.addInput(Items.field_151127_ba);
        PrimordialisReactorManager.addInput(Items.field_151081_bc);
        PrimordialisReactorManager.addInput(Blocks.field_150423_aK);
        PrimordialisReactorManager.addInput(Items.field_151080_bb);
        PrimordialisReactorManager.addInput(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b()));
        PrimordialisReactorManager.addInput("listAllfruit");
        PrimordialisReactorManager.addInput("listAllveggie");
        PrimordialisReactorManager.addInput("listAllseed");
        PrimordialisReactorManager.addInput("seed");
    }
}

