/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import java.util.HashMap;
import java.util.Map;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.SimpleRecipeManagerSecondaryOutput;
import lykrast.prodigytech.common.recipe.SimpleRecipeSecondaryOutput;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.RecipeUtil;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class OreRefineryManager
extends SimpleRecipeManagerSecondaryOutput {
    public static final OreRefineryManager INSTANCE = new OreRefineryManager();
    private Map<String, String[]> secondaryOres;

    public SimpleRecipeSecondaryOutput addRecipe(ItemStack in, ItemStack out) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(in, out, Config.oreRefineryProcessTime));
    }

    public SimpleRecipeSecondaryOutput addRecipe(String inOre, ItemStack out) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(inOre, out, Config.oreRefineryProcessTime));
    }

    public SimpleRecipeSecondaryOutput addRecipe(ItemStack in, ItemStack out, ItemStack secondary) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(in, out, secondary, Config.oreRefineryProcessTime));
    }

    public SimpleRecipeSecondaryOutput addRecipe(String inOre, ItemStack out, ItemStack secondary) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(inOre, out, secondary, Config.oreRefineryProcessTime));
    }

    public SimpleRecipeSecondaryOutput addRecipe(ItemStack in, ItemStack out, ItemStack secondary, float secondaryChance) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(in, out, secondary, Config.oreRefineryProcessTime, secondaryChance));
    }

    public SimpleRecipeSecondaryOutput addRecipe(String inOre, ItemStack out, ItemStack secondary, float secondaryChance) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(inOre, out, secondary, Config.oreRefineryProcessTime, secondaryChance));
    }

    @Override
    public void init() {
        this.secondaryOres = new HashMap<String, String[]>();
        this.secondaryOres.put("Iron", new String[]{"dustNickel", "dustGold"});
        this.secondaryOres.put("Gold", new String[]{"dustCopper", "dustSilver"});
        this.secondaryOres.put("Copper", new String[]{"dustGold"});
        this.secondaryOres.put("Tin", new String[]{"dustIron"});
        this.secondaryOres.put("Silver", new String[]{"dustLead"});
        this.secondaryOres.put("Lead", new String[]{"dustSilver", "dustCopper"});
        this.secondaryOres.put("Aluminum", new String[]{"dustIron"});
        this.secondaryOres.put("Aluminium", new String[]{"dustIron"});
        this.secondaryOres.put("Nickel", new String[]{"dustPlatinum", "dustIron"});
        this.secondaryOres.put("Platinum", new String[]{"dustIridium", "dustNickel"});
        this.secondaryOres.put("Iridium", new String[]{"dustPlatinum"});
        ItemStack sulfur = RecipeUtil.oreExists("dustSulfur") ? RecipeUtil.getPreferredOreStack("dustSulfur") : ItemStack.field_190927_a;
        this.addRecipe("oreCoal", new ItemStack(ModItems.coalDust, Config.oreRefineryOreMultiplier), sulfur, Config.oreRefineryChance);
        if (!Config.autoOreRecipes) {
            this.addRecipe("oreIron", new ItemStack(ModItems.ironDust, Config.oreRefineryOreMultiplier), new ItemStack(ModItems.goldDust), Config.oreRefineryChance);
        }
        if (!Config.autoOreRecipes) {
            this.addRecipe("oreGold", new ItemStack(ModItems.goldDust, Config.oreRefineryOreMultiplier));
        }
        this.addRecipe("oreLapis", new ItemStack(Items.field_151100_aR, 6 * Config.oreRefineryOreMultiplier, 4), sulfur, Config.oreRefineryChance);
        this.addRecipe("oreRedstone", new ItemStack(Items.field_151137_ax, (int)(4.5 * (double)Config.oreRefineryOreMultiplier)));
        if (!Config.autoOreRecipes) {
            this.addRecipe("oreDiamond", new ItemStack(ModItems.diamondDust, Config.oreRefineryOreMultiplier));
        }
        if (!Config.autoOreRecipes) {
            this.addRecipe("oreEmerald", new ItemStack(ModItems.emeraldDust, Config.oreRefineryOreMultiplier));
        }
        this.addRecipe("oreQuartz", new ItemStack(ModItems.quartzDust, Config.oreRefineryOreMultiplier), sulfur, Config.oreRefineryChance);
    }

    public void addOreRecipe(String ore, String input, String output) {
        ItemStack stackOutput = RecipeUtil.getPreferredOreStack(output);
        stackOutput.func_190920_e(Config.oreRefineryOreMultiplier);
        ItemStack stackSecondary = this.getPreferredSecondary(ore);
        this.addRecipe(input, stackOutput, stackSecondary, Config.oreRefineryChance);
    }

    private ItemStack getPreferredSecondary(String ore) {
        String[] secondary = this.secondaryOres.get(ore);
        if (secondary == null) {
            return ItemStack.field_190927_a;
        }
        for (String s : secondary) {
            if (!RecipeUtil.oreExists(s)) continue;
            return RecipeUtil.getPreferredOreStack(s);
        }
        return ItemStack.field_190927_a;
    }
}

