/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import lykrast.prodigytech.common.init.ModBlocks;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.SimpleRecipe;
import lykrast.prodigytech.common.recipe.SimpleRecipeManager;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.RecipeUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class MagneticReassemblerManager
extends SimpleRecipeManager {
    public static final MagneticReassemblerManager INSTANCE = new MagneticReassemblerManager();

    public SimpleRecipe addRecipe(ItemStack in, ItemStack out) {
        return this.addRecipe(in, out, Config.magneticReassemblerProcessTime);
    }

    public SimpleRecipe addRecipe(String inOre, ItemStack out) {
        return this.addRecipe(inOre, out, Config.magneticReassemblerProcessTime);
    }

    @Override
    public void init() {
        this.addRecipe("cobblestone", new ItemStack(Blocks.field_150348_b));
        this.addRecipe("gravel", new ItemStack(Blocks.field_150347_e));
        this.addRecipe("sand", new ItemStack(Blocks.field_150351_n));
        if (RecipeUtil.oreExists("dust")) {
            this.addRecipe("dust", new ItemStack((Block)Blocks.field_150354_m));
        }
        if (RecipeUtil.itemExists("exnihilocreatio:block_netherrack_crushed")) {
            this.addRecipe(new ItemStack(RecipeUtil.getExteriorItem("exnihilocreatio:block_netherrack_crushed")), new ItemStack(Blocks.field_150424_aL));
        }
        if (RecipeUtil.itemExists("exnihilocreatio:block_endstone_crushed")) {
            this.addRecipe(new ItemStack(RecipeUtil.getExteriorItem("exnihilocreatio:block_endstone_crushed")), new ItemStack(Blocks.field_150377_bs));
        }
        if (RecipeUtil.oreExists("crushedGranite")) {
            this.addRecipe("crushedGranite", new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.GRANITE.func_176642_a()));
        }
        if (RecipeUtil.oreExists("crushedDiorite")) {
            this.addRecipe("crushedDiorite", new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.DIORITE.func_176642_a()));
        }
        if (RecipeUtil.oreExists("crushedAndesite")) {
            this.addRecipe("crushedAndesite", new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.ANDESITE.func_176642_a()));
        }
        this.addRecipe("cobblestoneCharred", new ItemStack(ModBlocks.charredStone));
        this.addRecipe("dustCoal", new ItemStack(Items.field_151044_h));
        if (!Config.autoOreRecipes) {
            this.addRecipe("dustIron", new ItemStack(Items.field_151042_j));
            this.addRecipe("dustTinyIron", new ItemStack(Items.field_191525_da), Config.magneticReassemblerProcessTime / 9);
            this.addRecipe("dustGold", new ItemStack(Items.field_151043_k));
            this.addRecipe("dustTinyGold", new ItemStack(Items.field_151074_bl), Config.magneticReassemblerProcessTime / 9);
            this.addRecipe("dustDiamond", new ItemStack(Items.field_151045_i));
            this.addRecipe("dustEmerald", new ItemStack(Items.field_151166_bC));
        }
        this.addRecipe("dustQuartz", new ItemStack(Items.field_151128_bU));
        this.addRecipe("dustFerramic", new ItemStack(ModItems.ferramicIngot));
        this.addRecipe("dustTinyFerramic", new ItemStack(ModItems.ferramicNugget), Config.magneticReassemblerProcessTime / 9);
        this.addRecipe("dustEnergion", new ItemStack(ModItems.energionCrystalSeed));
        this.addRecipe(new ItemStack(ModItems.infernoFuel), new ItemStack(ModItems.infernoCrystal), Config.magneticReassemblerProcessTime * 2);
        this.addRecipe(new ItemStack(Items.field_151102_aT), new ItemStack(ModItems.sugarCube));
    }
}

