/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import lykrast.prodigytech.common.util.RecipeUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class ItemMap<T> {
    private final HashMap<Pair<Item, Integer>, T> normal = new HashMap();
    private final HashMap<String, T> ore = new HashMap();

    public T add(ItemStack stack, T thing) {
        this.normal.put(RecipeUtil.stackToPair(stack), thing);
        return thing;
    }

    public T add(String ore, T thing) {
        this.ore.put(ore, thing);
        return thing;
    }

    public List<T> getAllContent() {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(this.normal.values());
        list.addAll(this.ore.values());
        return list;
    }

    @Nullable
    public T find(ItemStack in) {
        int[] ores;
        if (in.func_190926_b()) {
            return null;
        }
        T recipe = this.normal.get(RecipeUtil.stackToPair(in));
        if (recipe != null) {
            return recipe;
        }
        recipe = this.normal.get(RecipeUtil.stackToWildcardPair(in));
        if (recipe != null) {
            return recipe;
        }
        for (int i : ores = OreDictionary.getOreIDs((ItemStack)in)) {
            recipe = this.findOre(OreDictionary.getOreName((int)i));
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    public boolean isValid(ItemStack check) {
        return this.find(check) != null;
    }

    @Nullable
    public T findOre(String in) {
        return this.ore.get(in);
    }

    @Nullable
    public T remove(ItemStack in) {
        T removed = this.normal.remove(RecipeUtil.stackToPair(in));
        if (removed != null) {
            return removed;
        }
        return this.normal.remove(RecipeUtil.stackToWildcardPair(in));
    }

    @Nullable
    public T remove(String in) {
        return this.ore.remove(in);
    }

    public void clear() {
        this.normal.clear();
        this.ore.clear();
    }
}

