/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import lykrast.prodigytech.common.init.ModBlocks;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.SimpleRecipeManagerSecondaryOutput;
import lykrast.prodigytech.common.recipe.SimpleRecipeSecondaryOutput;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.OreIngredient;

public class HeatSawmillManager
extends SimpleRecipeManagerSecondaryOutput {
    public static final HeatSawmillManager INSTANCE = new HeatSawmillManager();

    public SimpleRecipeSecondaryOutput addRecipe(ItemStack in, ItemStack out) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(in, out, Config.heatSawmillProcessTime));
    }

    public SimpleRecipeSecondaryOutput addRecipe(String inOre, ItemStack out) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(inOre, out, Config.heatSawmillProcessTime));
    }

    public SimpleRecipeSecondaryOutput addRecipe(ItemStack in, ItemStack out, ItemStack secondary) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(in, out, secondary, Config.heatSawmillProcessTime));
    }

    public SimpleRecipeSecondaryOutput addRecipe(String inOre, ItemStack out, ItemStack secondary) {
        return this.addRecipe(new SimpleRecipeSecondaryOutput(inOre, out, secondary, Config.heatSawmillProcessTime));
    }

    @Override
    public void init() {
        this.addRecipe("plankWood", new ItemStack(Items.field_151055_y, (int)(2.0f * Config.heatSawmillStickMultiplier)), new ItemStack(ModItems.sawdust));
        if (!Config.heatSawmillAutoPlankRecipes) {
            int i;
            for (i = 0; i <= 3; ++i) {
                this.registerPlank(new ItemStack(Blocks.field_150364_r, 1, i), new ItemStack(Blocks.field_150344_f, 4, i));
            }
            for (i = 0; i <= 1; ++i) {
                this.registerPlank(new ItemStack(Blocks.field_150363_s, 1, i), new ItemStack(Blocks.field_150344_f, 4, i + 4));
            }
            this.registerPlank(new ItemStack(ModBlocks.zorraLog), new ItemStack(ModBlocks.zorraPlanks, 4));
        }
    }

    public void registerPlanks() {
        ItemStack[] ores;
        if (!Config.heatSawmillAutoPlankRecipes) {
            return;
        }
        InventoryCraftingFalse tempCrafting = new InventoryCraftingFalse(3, 3);
        for (int i = 0; i < 9; ++i) {
            tempCrafting.func_70299_a(i, ItemStack.field_190927_a);
        }
        for (ItemStack log : ores = new OreIngredient("logWood").func_193365_a()) {
            ItemStack log1 = log.func_77946_l();
            log1.func_190920_e(1);
            tempCrafting.func_70299_a(0, log1);
            ItemStack result = CraftingManager.func_82787_a((InventoryCrafting)tempCrafting, null);
            if (result.func_190926_b()) continue;
            this.registerPlank(log1, result.func_77946_l());
        }
    }

    private void registerPlank(ItemStack log, ItemStack plank) {
        plank.func_190920_e(Math.min(plank.func_77976_d(), (int)((float)plank.func_190916_E() * Config.heatSawmillPlankMultiplier)));
        this.addRecipe(log, plank, new ItemStack(ModItems.sawdust));
    }

    private static class InventoryCraftingFalse
    extends InventoryCrafting {
        private static final NullContainer nullContainer = new NullContainer();

        public InventoryCraftingFalse(int width, int height) {
            super((Container)nullContainer, width, height);
        }

        public static class NullContainer
        extends Container {
            public void func_75130_a(IInventory inventory) {
            }

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }
    }
}

