/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lykrast.prodigytech.common.init.ModBlocks;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.ItemMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.oredict.OreIngredient;

public class ExplosionFurnaceManager {
    public static final List<ExplosionFurnaceRecipe> RECIPES = new ArrayList<ExplosionFurnaceRecipe>();
    public static final ItemMap<Explosive> EXPLOSIVES = new ItemMap();
    public static final ItemMap<Dampener> DAMPENERS = new ItemMap();

    public static ExplosionFurnaceRecipe addRecipe(ItemStack input, ItemStack output, int power) {
        return ExplosionFurnaceManager.addRecipe(new ExplosionFurnaceRecipe(input, output, power));
    }

    public static ExplosionFurnaceRecipe addRecipe(String input, int inputCount, ItemStack output, int power) {
        return ExplosionFurnaceManager.addRecipe(new ExplosionFurnaceRecipe(input, inputCount, output, power));
    }

    public static ExplosionFurnaceRecipe addRecipe(ItemStack input, ItemStack output, int power, ItemStack reagent, int craftPerReagent) {
        return ExplosionFurnaceManager.addRecipe(new ExplosionFurnaceRecipe(input, output, power, reagent, craftPerReagent));
    }

    public static ExplosionFurnaceRecipe addRecipe(String input, int inputCount, ItemStack output, int power, ItemStack reagent, int craftPerReagent) {
        return ExplosionFurnaceManager.addRecipe(new ExplosionFurnaceRecipe(input, inputCount, output, power, reagent, craftPerReagent));
    }

    public static ExplosionFurnaceRecipe addRecipe(ItemStack input, ItemStack output, int power, String reagent, int craftPerReagent) {
        return ExplosionFurnaceManager.addRecipe(new ExplosionFurnaceRecipe(input, output, power, reagent, craftPerReagent));
    }

    public static ExplosionFurnaceRecipe addRecipe(String input, int inputCount, ItemStack output, int power, String reagent, int craftPerReagent) {
        return ExplosionFurnaceManager.addRecipe(new ExplosionFurnaceRecipe(input, inputCount, output, power, reagent, craftPerReagent));
    }

    public static ExplosionFurnaceRecipe addRecipe(ExplosionFurnaceRecipe recipe) {
        RECIPES.add(recipe);
        return recipe;
    }

    public static ExplosionFurnaceRecipe removeRecipeByOutput(ItemStack out) {
        for (ExplosionFurnaceRecipe recipe : RECIPES) {
            if (!out.func_77969_a(recipe.getOutput())) continue;
            RECIPES.remove(recipe);
            return recipe;
        }
        return null;
    }

    public static ExplosionFurnaceRecipe findRecipe(ItemStack in, ItemStack reagent) {
        ExplosionFurnaceRecipe backup = null;
        for (ExplosionFurnaceRecipe recipe : RECIPES) {
            if (!recipe.isValidInput(in)) continue;
            if (recipe.isValidReagent(reagent)) {
                return recipe;
            }
            if (recipe.needReagent()) continue;
            backup = recipe;
        }
        return backup;
    }

    public static void removeAllRecipes() {
        RECIPES.clear();
    }

    public static Explosive addExplosive(ItemStack item, int power) {
        Explosive explosive = new Explosive(item, power);
        EXPLOSIVES.add(item, explosive);
        return explosive;
    }

    public static Explosive addExplosive(String ore, int power) {
        Explosive explosive = new Explosive(ore, power);
        EXPLOSIVES.add(ore, explosive);
        return explosive;
    }

    public static Dampener addDampener(ItemStack item, int power) {
        Dampener dampener = new Dampener(item, power);
        DAMPENERS.add(item, dampener);
        return dampener;
    }

    public static Dampener addDampener(String ore, int power) {
        Dampener dampener = new Dampener(ore, power);
        DAMPENERS.add(ore, dampener);
        return dampener;
    }

    public static Explosive findExplosive(ItemStack explosive) {
        return EXPLOSIVES.find(explosive);
    }

    public static Explosive removeExplosive(ItemStack explosive) {
        return EXPLOSIVES.remove(explosive);
    }

    public static Explosive removeExplosive(String ore) {
        return EXPLOSIVES.remove(ore);
    }

    public static Dampener findDampener(ItemStack dampener) {
        return DAMPENERS.find(dampener);
    }

    public static Dampener removeDampener(ItemStack dampener) {
        return DAMPENERS.remove(dampener);
    }

    public static Dampener removeDampener(String ore) {
        return DAMPENERS.remove(ore);
    }

    public static void removeAllExplosives() {
        EXPLOSIVES.clear();
    }

    public static void removeAllDampeners() {
        DAMPENERS.clear();
    }

    public static boolean isValidInput(ItemStack check) {
        for (ExplosionFurnaceRecipe recipe : RECIPES) {
            if (!recipe.isValidInput(check)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidReagent(ItemStack check) {
        for (ExplosionFurnaceRecipe recipe : RECIPES) {
            if (!recipe.isValidReagent(check)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidExplosive(ItemStack check) {
        return EXPLOSIVES.isValid(check);
    }

    public static boolean isValidDampener(ItemStack check) {
        return DAMPENERS.isValid(check);
    }

    public static void init() {
        ExplosionFurnaceManager.addRecipe("ingotIron", 1, new ItemStack(ModItems.ferramicIngot), 90, new ItemStack(Items.field_151119_aD), 4);
        ExplosionFurnaceManager.addRecipe("ingotIron", 1, new ItemStack(ModItems.ferramicIngot), 90, new ItemStack(Blocks.field_150435_aG), 16);
        ExplosionFurnaceManager.addRecipe("nuggetIron", 1, new ItemStack(ModItems.ferramicNugget), 10, new ItemStack(Items.field_151119_aD), 36);
        ExplosionFurnaceManager.addRecipe("nuggetIron", 1, new ItemStack(ModItems.ferramicNugget), 10, new ItemStack(Blocks.field_150435_aG), 144);
        ExplosionFurnaceManager.addRecipe("ingotRawZorrasteel", 1, new ItemStack(ModItems.zorrasteelIngot), 360, "dustCoal", 1);
        ExplosionFurnaceManager.addRecipe("stone", 1, new ItemStack(ModBlocks.charredCobblestone), 45);
        ExplosionFurnaceManager.addRecipe("cobblestone", 1, new ItemStack(Blocks.field_150351_n), 45);
        ExplosionFurnaceManager.addRecipe("stoneCharred", 1, new ItemStack(ModBlocks.charredCobblestone), 45);
        ExplosionFurnaceManager.addRecipe("cobblestoneCharred", 1, new ItemStack(Blocks.field_150351_n), 45);
        ExplosionFurnaceManager.addExplosive("gunpowder", 288);
        ExplosionFurnaceManager.addExplosive("dustWood", 30);
        ExplosionFurnaceManager.addExplosive("dustEnergion", 1440);
        ExplosionFurnaceManager.addDampener("sand", 360);
        ExplosionFurnaceManager.addDampener("dustAsh", 30);
    }

    public static class Dampener {
        private final Ingredient ingredient;
        private final int dampening;

        public Dampener(ItemStack explosive, int dampening) {
            this.ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{explosive});
            this.dampening = dampening;
        }

        public Dampener(String oreExplosive, int dampening) {
            this.ingredient = new OreIngredient(oreExplosive);
            this.dampening = dampening;
        }

        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b() && this.ingredient.apply(stack);
        }

        public int getDampening() {
            return this.dampening;
        }

        public int getDampening(ItemStack stack) {
            return this.dampening * stack.func_190916_E();
        }

        public List<ItemStack> getMatchingStacks() {
            return Arrays.asList(this.ingredient.func_193365_a());
        }
    }

    public static class Explosive {
        private final Ingredient ingredient;
        private final int power;

        public Explosive(ItemStack explosive, int power) {
            this.ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{explosive});
            this.power = power;
        }

        public Explosive(String oreExplosive, int power) {
            this.ingredient = new OreIngredient(oreExplosive);
            this.power = power;
        }

        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b() && this.ingredient.apply(stack);
        }

        public int getPower() {
            return this.power;
        }

        public int getPower(ItemStack stack) {
            return this.power * stack.func_190916_E();
        }

        public List<ItemStack> getMatchingStacks() {
            return Arrays.asList(this.ingredient.func_193365_a());
        }
    }

    public static class ExplosionFurnaceRecipe {
        private final Ingredient input;
        private final Ingredient reagent;
        private final ItemStack output;
        private final int power;
        private final int inputCount;
        private final int craftPerReagent;

        public ExplosionFurnaceRecipe(ItemStack input, ItemStack output, int power) {
            this(input, output, power, ItemStack.field_190927_a, 0);
        }

        public ExplosionFurnaceRecipe(String input, int inputCount, ItemStack output, int power) {
            this(input, inputCount, output, power, ItemStack.field_190927_a, 0);
        }

        public ExplosionFurnaceRecipe(ItemStack input, ItemStack output, int power, ItemStack reagent, int craftPerReagent) {
            this(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), input.func_190916_E(), output, power, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{reagent}), craftPerReagent);
        }

        public ExplosionFurnaceRecipe(String input, int inputCount, ItemStack output, int power, ItemStack reagent, int craftPerReagent) {
            this((Ingredient)new OreIngredient(input), inputCount, output, power, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{reagent}), craftPerReagent);
        }

        public ExplosionFurnaceRecipe(ItemStack input, ItemStack output, int power, String reagent, int craftPerReagent) {
            this(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), input.func_190916_E(), output, power, (Ingredient)new OreIngredient(reagent), craftPerReagent);
        }

        public ExplosionFurnaceRecipe(String input, int inputCount, ItemStack output, int power, String reagent, int craftPerReagent) {
            this((Ingredient)new OreIngredient(input), inputCount, output, power, (Ingredient)new OreIngredient(reagent), craftPerReagent);
        }

        private ExplosionFurnaceRecipe(Ingredient input, int inputCount, ItemStack output, int power, Ingredient reagent, int craftPerReagent) {
            this.input = input;
            this.inputCount = inputCount;
            this.output = output;
            this.power = power;
            this.reagent = reagent;
            this.craftPerReagent = craftPerReagent;
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public int getRequiredPower() {
            return this.power;
        }

        public boolean needReagent() {
            return this.reagent != Ingredient.field_193370_a && this.craftPerReagent > 0;
        }

        public int getCraftPerReagent() {
            return this.craftPerReagent;
        }

        public boolean isValidInput(ItemStack in) {
            return !in.func_190926_b() && this.input.apply(in) && in.func_190916_E() >= this.inputCount;
        }

        public boolean isValidReagent(ItemStack reag) {
            return this.reagent.apply(reag);
        }

        public int getInputCount() {
            return this.inputCount;
        }

        public List<ItemStack> getInputs() {
            ItemStack[] array = this.input.func_193365_a();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            int amount = this.needReagent() ? this.inputCount * this.craftPerReagent : this.inputCount;
            for (int i = 0; i < array.length; ++i) {
                ItemStack stack = array[i].func_77946_l();
                stack.func_190920_e(amount);
                list.add(stack);
            }
            return list;
        }

        public List<ItemStack> getReagents() {
            return Arrays.asList(this.reagent.func_193365_a());
        }
    }
}

