/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lykrast.prodigytech.common.init.ModBlocks;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.ISingleInputRecipe;
import lykrast.prodigytech.common.recipe.SimpleRecipeManagerAbstract;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.RecipeUtil;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AtomicReshaperManager
extends SimpleRecipeManagerAbstract<AtomicReshaperRecipe> {
    public static final AtomicReshaperManager INSTANCE = new AtomicReshaperManager();

    private AtomicReshaperManager() {
    }

    public AtomicReshaperRecipe addRecipe(ItemStack input, int time, int primordium, Object ... outputs) {
        return this.addRecipe(new AtomicReshaperRecipe(input, time, primordium, outputs));
    }

    public AtomicReshaperRecipe addRecipe(String input, int time, int primordium, Object ... outputs) {
        return this.addRecipe(new AtomicReshaperRecipe(input, time, primordium, outputs));
    }

    @Override
    public void init() {
        this.addRecipe("treeSapling", Config.atomicReshaperProcessTime, 50, new ItemStack(ModBlocks.zorraSapling));
        this.addRecipe("stone", Config.atomicReshaperProcessTime, 20, AtomicReshaperManager.createOreDictOutputs("oreAluminum", 3940, "oreAmber", 2075, "oreApatite", 1595, "oreCertusQuartz", 3975, "oreCinnabar", 2585, "oreCoal", 46525, "oreCopper", 8325, "oreDiamond", 1265, "oreEmerald", 780, "oreGalena", 1000, "oreGold", 2970, "oreIron", 20665, "oreLapis", 1285, "oreLead", 7985, "oreMithril", 8, "oreNickel", 2275, "orePlatinum", 365, "oreRedstone", 6885, "oreRuby", 1100, "oreSapphire", 1100, "oreSilver", 6300, "oreTin", 9450, "oreUranium", 1337, "oreOsmium", 6915, "oreQuartzBlack", 5535));
        this.addRecipe("cobblestone", Config.atomicReshaperProcessTime, 4, AtomicReshaperManager.createOreDictOutputs("stoneGranite", 1, "stoneDiorite", 1, "stoneAndesite", 1, "stoneMarble", 1, "stoneBasalt", 1, "stoneLimestone", 1, "slate", 1));
        this.addRecipe("sand", Config.atomicReshaperProcessTime, 1, new ItemStack(Blocks.field_150346_d));
        this.addRecipe("dirt", Config.atomicReshaperProcessTime, 3, new ItemStack(Blocks.field_150435_aG));
        this.addRecipe("paper", Config.atomicReshaperProcessTime, 2, new ItemStack(ModItems.circuitPlate));
        this.addRecipe("dustAsh", Config.atomicReshaperProcessTime, 2, new ItemStack(Items.field_151016_H));
        this.addRecipe(new ItemStack(ModItems.infernoCrystal), Config.atomicReshaperProcessTime, 5, new ItemStack(ModItems.aeternusCrystal));
    }

    private static Object[] createOreDictOutputs(Object ... outputs) {
        ArrayList<Object> processed = new ArrayList<Object>();
        for (int i = 0; i < outputs.length; i += 2) {
            String cast = (String)outputs[i];
            if (!RecipeUtil.oreExists(cast)) continue;
            Integer weight = (Integer)outputs[i + 1];
            processed.add(RecipeUtil.getPreferredOreStack(cast));
            processed.add(weight);
        }
        return processed.toArray();
    }

    public static class AtomicReshaperRecipe
    implements ISingleInputRecipe,
    Comparable<AtomicReshaperRecipe> {
        private static int NEXTID = 0;
        private int id;
        protected final ItemStack input;
        protected final String oreInput;
        protected final List<Pair<ItemStack, Integer>> outputs;
        protected final int time;
        protected final int primordium;
        private int totalWeight;

        public AtomicReshaperRecipe(ItemStack input, int time, int primordium, Object ... outputs) {
            this.input = input;
            this.oreInput = null;
            this.time = time;
            this.primordium = primordium;
            this.outputs = new ArrayList<Pair<ItemStack, Integer>>();
            this.processOutputs(outputs);
            this.id = NEXTID++;
        }

        public AtomicReshaperRecipe(String input, int time, int primordium, Object ... outputs) {
            this.input = ItemStack.field_190927_a;
            this.oreInput = input;
            this.time = time;
            this.primordium = primordium;
            this.outputs = new ArrayList<Pair<ItemStack, Integer>>();
            this.processOutputs(outputs);
            this.id = NEXTID++;
        }

        private void processOutputs(Object[] args) {
            if (args.length == 1) {
                if (!(args[0] instanceof ItemStack)) {
                    throw new IllegalArgumentException("Lists with single outputs need to be ItemStack");
                }
                this.outputs.add((Pair<ItemStack, Integer>)new ImmutablePair((Object)((ItemStack)args[0]), (Object)1));
                this.totalWeight = 1;
            } else {
                if (args.length <= 0) {
                    throw new IllegalArgumentException("Must have at least one output");
                }
                if (args.length % 2 != 0) {
                    throw new IllegalArgumentException("Must have 1 or an even number of output arguments");
                }
                this.totalWeight = 0;
                for (int i = 0; i < args.length; i += 2) {
                    if (!(args[i] instanceof ItemStack) || !(args[i + 1] instanceof Integer)) {
                        throw new IllegalArgumentException("Output arguments must be alternating between ItemStacks and integers, in that order");
                    }
                    Integer w = (Integer)args[i + 1];
                    this.outputs.add((Pair<ItemStack, Integer>)new ImmutablePair((Object)((ItemStack)args[i]), (Object)w));
                    this.totalWeight += w.intValue();
                }
            }
        }

        @Override
        public boolean isOreRecipe() {
            return this.oreInput != null && this.input.func_190926_b();
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public String getOreInput() {
            return this.oreInput;
        }

        public int getTimeTicks() {
            return this.time;
        }

        public int getTimeProcessing() {
            return this.time * 10;
        }

        public int getPrimordiumAmount() {
            return this.primordium;
        }

        public boolean isSingleOutput() {
            return this.outputs.size() == 1;
        }

        public ItemStack getSingleOutput() {
            return ((ItemStack)this.outputs.get(0).getLeft()).func_77946_l();
        }

        public List<ItemStack> getOutputList() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            this.outputs.stream().forEach(p -> list.add(((ItemStack)p.getLeft()).func_77946_l()));
            return list;
        }

        public int[] getWeights() {
            int[] array = new int[this.outputs.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Integer)this.outputs.get(i).getRight();
            }
            return array;
        }

        public int getTotalWeight() {
            return this.totalWeight;
        }

        public ItemStack getRandomOutput(Random rand) {
            int index = rand.nextInt(this.totalWeight);
            for (Pair<ItemStack, Integer> p : this.outputs) {
                if (index < (Integer)p.getRight()) {
                    return ((ItemStack)p.getLeft()).func_77946_l();
                }
                index -= ((Integer)p.getRight()).intValue();
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public boolean isValidInput(ItemStack in) {
            if (in.func_190926_b()) {
                return false;
            }
            if (this.oreInput != null) {
                int[] oreIDs;
                for (int i : oreIDs = OreDictionary.getOreIDs((ItemStack)in)) {
                    if (!OreDictionary.getOreName((int)i).equals(this.oreInput)) continue;
                    return true;
                }
                return false;
            }
            return in.func_77969_a(this.input) && in.func_190916_E() >= this.input.func_190916_E();
        }

        @Override
        public int compareTo(AtomicReshaperRecipe other) {
            return Integer.compareUnsigned(this.id, other.id);
        }
    }
}

