/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import lykrast.prodigytech.common.init.ModItems;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemMysteryTreat
extends ItemFood {
    public static final IItemColor COLOR = new Color();
    private static final List<PotionEffect[]> EFFECTS = new ArrayList<PotionEffect[]>();

    public static void initEffects() {
        ItemMysteryTreat.registerEffect(MobEffects.field_76424_c, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_76421_d, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_76422_e, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_76419_f, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_76420_g, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_76432_h, 1);
        ItemMysteryTreat.registerEffect(MobEffects.field_76433_i, 1);
        ItemMysteryTreat.registerEffect(MobEffects.field_76430_j, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_76428_l, 900);
        ItemMysteryTreat.registerEffect(MobEffects.field_76429_m, 3600);
        ItemMysteryTreat.registerEffectSingleAmplifier(MobEffects.field_76426_n, 3600, 7200, 10800);
        ItemMysteryTreat.registerEffectSingleAmplifier(MobEffects.field_76427_o, 3600, 7200, 10800);
        ItemMysteryTreat.registerEffectSingleAmplifier(MobEffects.field_76441_p, 3600, 7200, 10800);
        ItemMysteryTreat.registerEffectSingleAmplifier(MobEffects.field_76440_q, 3600, 7200, 10800);
        ItemMysteryTreat.registerEffectSingleAmplifier(MobEffects.field_76439_r, 3600, 7200, 10800);
        ItemMysteryTreat.registerEffect(MobEffects.field_76438_s, 900);
        ItemMysteryTreat.registerEffect(MobEffects.field_76437_t, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_76436_u, 900);
        ItemMysteryTreat.registerEffect(MobEffects.field_82731_v, 900);
        ItemMysteryTreat.registerEffect(MobEffects.field_180152_w, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_76444_x, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_188424_y, 400);
        ItemMysteryTreat.registerEffect(MobEffects.field_188425_z, 3600);
        ItemMysteryTreat.registerEffect(MobEffects.field_189112_A, 3600);
    }

    public static void registerEffect(Potion potion, int duration) {
        PotionEffect[] array = new PotionEffect[3];
        for (int i = 0; i < 3; ++i) {
            array[i] = new PotionEffect(potion, duration, i);
        }
        EFFECTS.add(array);
    }

    public static void registerEffectSingleAmplifier(Potion potion, int duration1, int duration2, int duration3) {
        PotionEffect[] array = new PotionEffect[]{new PotionEffect(potion, duration1), new PotionEffect(potion, duration2), new PotionEffect(potion, duration3)};
        EFFECTS.add(array);
    }

    public ItemMysteryTreat(int amount, float saturation) {
        super(amount, saturation, false);
        this.func_77848_i();
    }

    protected void func_77849_c(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K && stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_74764_b("back")) {
                this.applyEffect(PotionEffect.func_82722_b((NBTTagCompound)nbt.func_74775_l("back")), player);
            }
            if (nbt.func_74764_b("front")) {
                this.applyEffect(PotionEffect.func_82722_b((NBTTagCompound)nbt.func_74775_l("front")), player);
            }
        }
    }

    private void applyEffect(PotionEffect effect, EntityPlayer player) {
        if (effect == null) {
            return;
        }
        if (effect.func_188419_a().func_76403_b()) {
            effect.func_188419_a().func_180793_a((Entity)player, (Entity)player, (EntityLivingBase)player, effect.func_76458_c(), 1.0);
        } else {
            player.func_70690_d(new PotionEffect(effect));
        }
    }

    public static ItemStack createWithEffect(PotionEffect back) {
        return ItemMysteryTreat.createWithEffect(back, null);
    }

    public static ItemStack createWithEffect(PotionEffect back, PotionEffect front) {
        ItemStack stack = new ItemStack(ModItems.mysteryTreat);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("back", (NBTBase)back.func_82719_a(new NBTTagCompound()));
        if (front != null) {
            nbt.func_74782_a("front", (NBTBase)front.func_82719_a(new NBTTagCompound()));
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack createRandom(Random rand) {
        int size = EFFECTS.size();
        int i = rand.nextInt(size);
        int j = rand.nextInt(size);
        if (j == i) {
            return ItemMysteryTreat.createWithEffect(EFFECTS.get(i)[2]);
        }
        return ItemMysteryTreat.createWithEffect(EFFECTS.get(i)[1], EFFECTS.get(j)[0]);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        if (EFFECTS.isEmpty()) {
            items.add((Object)new ItemStack((Item)this));
            return;
        }
        int size = EFFECTS.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (j == i) {
                    items.add((Object)ItemMysteryTreat.createWithEffect(EFFECTS.get(i)[2]));
                    continue;
                }
                items.add((Object)ItemMysteryTreat.createWithEffect(EFFECTS.get(i)[1], EFFECTS.get(j)[0]));
            }
        }
    }

    private static class Color
    implements IItemColor {
        private Color() {
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            if (!stack.func_77942_o()) {
                return -1;
            }
            NBTTagCompound nbt = stack.func_77978_p();
            if (tintIndex == 0 && nbt.func_74764_b("back")) {
                return PotionUtils.func_185181_a(Collections.singleton(PotionEffect.func_82722_b((NBTTagCompound)nbt.func_74775_l("back"))));
            }
            if (tintIndex == 1) {
                if (nbt.func_74764_b("front")) {
                    return PotionUtils.func_185181_a(Collections.singleton(PotionEffect.func_82722_b((NBTTagCompound)nbt.func_74775_l("front"))));
                }
                return this.func_186726_a(stack, 0);
            }
            return -1;
        }
    }
}

