/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.item;

import java.util.List;
import lykrast.prodigytech.common.item.IHeatCapacitor;
import lykrast.prodigytech.common.item.ItemInfoShift;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.TooltipUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHeatCapacitor
extends ItemInfoShift
implements IHeatCapacitor {
    private int temperature;
    private static final String TOOLTIP_BASE = "item.prodigytech.heat_capacitor.tooltip";
    private static final String TOOLTIP_CHARGE = "item.prodigytech.heat_capacitor.tooltip.charge";

    public ItemHeatCapacitor(int temperature) {
        this.temperature = temperature;
        this.func_77625_d(1);
        this.func_77656_e(Config.heatCapacitorDuration);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
            items.add((Object)new ItemStack((Item)this, 1, 0));
        }
    }

    @Override
    public boolean isFullyCharged(ItemStack stack) {
        return stack.func_77952_i() == 0;
    }

    @Override
    public boolean isDepleted(ItemStack stack) {
        return stack.func_77952_i() >= stack.func_77958_k();
    }

    @Override
    public void charge(ItemStack stack, int ticks) {
        stack.func_77964_b(Math.max(0, stack.func_77952_i() - ticks));
    }

    @Override
    public void discharge(ItemStack stack, int ticks) {
        stack.func_77964_b(Math.min(stack.func_77958_k(), stack.func_77952_i() + ticks));
    }

    @Override
    public int getTargetTemperature(ItemStack stack) {
        return this.temperature;
    }

    @Override
    public int getChargeLeft(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        return stack.func_77958_k();
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 6.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addInfo(ItemStack stack, List<String> tooltip) {
        String[] lines;
        String tip = I18n.func_135052_a((String)TOOLTIP_BASE, (Object[])new Object[0]);
        for (String s : lines = tip.split("\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
        TooltipUtil.addAeroheaterInfo(stack, tooltip, this.temperature);
        tooltip.add(I18n.func_135052_a((String)TOOLTIP_CHARGE, (Object[])new Object[]{100 - 100 * stack.func_77952_i() / stack.func_77958_k()}));
    }
}

