/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.item;

import java.util.List;
import javax.annotation.Nullable;
import lykrast.prodigytech.common.init.ModItems;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFoodPurified
extends ItemFood {
    public static final String NBT_FOOD = "Food";
    public static final String NBT_SATURATION = "Saturation";
    private static final double[][] COLORS = new double[][]{{0.3882353f, 0.4274509847164154, 0.11764705926179886}, {1.0, 0.46666666865348816, 0.46666666865348816}, {0.5803921818733215, 0.3490196168422699, 0.2549019753932953}, {1.0, 1.0, 0.0}, {0.5490196347236633, 0.95686274766922, 0.886274516582489}};

    public ItemFoodPurified() {
        super(0, 0.0f, false);
        this.func_185043_a(new ResourceLocation("food"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (!stack.func_77942_o()) {
                    return 0.0f;
                }
                return stack.func_77978_p().func_74762_e(ItemFoodPurified.NBT_FOOD);
            }
        });
    }

    public static ItemStack make(int food, float saturation) {
        ItemStack stack = new ItemStack(ModItems.purifiedFood);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a(NBT_FOOD, food);
        nbt.func_74776_a(NBT_SATURATION, saturation);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack make(ItemStack stack) {
        ItemFood food = (ItemFood)stack.func_77973_b();
        return ItemFoodPurified.make(food.func_150905_g(stack), food.func_150906_h(stack));
    }

    public int func_150905_g(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(NBT_FOOD);
    }

    public float func_150906_h(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0.0f;
        }
        return stack.func_77978_p().func_74760_g(NBT_SATURATION);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String[] lines;
        String tip = I18n.func_135052_a((String)(stack.func_77977_a() + ".tooltip"), (Object[])new Object[]{this.func_150905_g(stack), Float.valueOf(this.func_150906_h(stack))});
        for (String s : lines = tip.split("\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        double down;
        double up;
        int index;
        if (tintIndex != 0 || !stack.func_77942_o()) {
            return -1;
        }
        float saturation = stack.func_77978_p().func_74760_g(NBT_SATURATION);
        if (saturation >= 2.0f) {
            return 9237730;
        }
        if (saturation <= 0.1f) {
            return 6515998;
        }
        if ((double)saturation >= 1.2) {
            index = 3;
            up = 2.0;
            down = 1.2;
        } else if ((double)saturation >= 0.8) {
            index = 2;
            up = 1.2;
            down = 0.8;
        } else if ((double)saturation >= 0.3) {
            index = 1;
            up = 0.8;
            down = 0.3;
        } else {
            index = 0;
            up = 0.3;
            down = 0.1;
        }
        double gradient = ((double)saturation - down) / (up - down);
        double inv = 1.0 - gradient;
        int red = (int)((COLORS[index][0] * inv + COLORS[index + 1][0] * gradient) * 255.0);
        int green = (int)((COLORS[index][1] * inv + COLORS[index + 1][1] * gradient) * 255.0);
        int blue = (int)((COLORS[index][2] * inv + COLORS[index + 1][2] * gradient) * 255.0);
        return red << 16 | green << 8 | blue;
    }
}

