/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.item;

import java.util.List;
import javax.annotation.Nullable;
import lykrast.prodigytech.common.block.BlockEnergionCrystal;
import lykrast.prodigytech.common.init.ModBlocks;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.item.ItemProdigyTool;
import lykrast.prodigytech.common.util.TooltipUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentUntouching;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrystalCutter
extends ItemProdigyTool {
    public ItemCrystalCutter(int harvestLevel, int durability, float harvestSpeed, int enchatability) {
        super("crystalcutter", harvestLevel, durability, harvestSpeed, enchatability, new ItemStack(ModItems.ferramicIngot));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.field_77351_y == EnumEnchantmentType.DIGGER && !(enchantment instanceof EnchantmentUntouching)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_150897_b(IBlockState block) {
        Material material = block.func_185904_a();
        return material == Material.field_151592_s;
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K && state.func_177230_c() == ModBlocks.energionCrystal) {
            stack.func_77972_a(BlockEnergionCrystal.getAge(state) + 1, entityLiving);
            BlockEnergionCrystal.defuse(worldIn, pos);
            return true;
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == ModBlocks.energionCrystal && player.func_175151_a(pos, facing, itemstack)) {
            if (worldIn.field_72995_K) {
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                return EnumActionResult.SUCCESS;
            }
            int age = BlockEnergionCrystal.getAge(state);
            if (age > 0) {
                worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                worldIn.func_175656_a(pos, ((BlockEnergionCrystal)ModBlocks.energionCrystal).withAge(age - 1));
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.energionCrystalSeed));
                int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack);
                if (fortune > 0) {
                    for (int j = 0; j < fortune; ++j) {
                        if (worldIn.field_73012_v.nextInt(2) != 0) continue;
                        Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.energionCrystalSeed));
                    }
                }
            } else {
                worldIn.func_175655_b(pos, true);
            }
            itemstack.func_77972_a(1, (EntityLivingBase)player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (TooltipUtil.addShiftTooltip(tooltip)) {
            TooltipUtil.addTooltip(stack, tooltip);
        }
    }
}

