/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.init;

import lykrast.prodigytech.common.init.ModBlocks;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.AtomicReshaperManager;
import lykrast.prodigytech.common.recipe.ExplosionFurnaceManager;
import lykrast.prodigytech.common.recipe.HeatSawmillManager;
import lykrast.prodigytech.common.recipe.MagneticReassemblerManager;
import lykrast.prodigytech.common.recipe.OreRefineryManager;
import lykrast.prodigytech.common.recipe.PrimordialisReactorManager;
import lykrast.prodigytech.common.recipe.RotaryGrinderManager;
import lykrast.prodigytech.common.recipe.SoldererManager;
import lykrast.prodigytech.common.tileentity.TileFuelProcessor;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.common.util.RecipeUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber
public class ModRecipes {
    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModRecipes.initSmelting();
        ExplosionFurnaceManager.init();
        RotaryGrinderManager.INSTANCE.init();
        SoldererManager.init();
        MagneticReassemblerManager.INSTANCE.init();
        HeatSawmillManager.INSTANCE.init();
        PrimordialisReactorManager.init();
        AtomicReshaperManager.INSTANCE.init();
        OreRefineryManager.INSTANCE.init();
        TileFuelProcessor.initBlacklist();
        ModRecipes.makeOreRecipes();
    }

    public static void makeOreRecipes() {
        if (!Config.autoOreRecipes) {
            return;
        }
        for (String name : OreDictionary.getOreNames()) {
            ItemStack output;
            String ore;
            if (!RecipeUtil.oreExists(name)) continue;
            if (name.startsWith("ore")) {
                ore = name.substring("ore".length());
                if (RecipeUtil.isOreBlacklisted(ore)) continue;
                if (RecipeUtil.oreExists("dust" + ore)) {
                    output = RecipeUtil.getPreferredOreStack("dust" + ore);
                    output.func_190920_e(Config.rotaryGrinderOreMultiplier);
                    RotaryGrinderManager.INSTANCE.addRecipe(name, output);
                    OreRefineryManager.INSTANCE.addOreRecipe(ore, name, "dust" + ore);
                    continue;
                }
                if (!RecipeUtil.oreExists("gem" + ore)) continue;
                output = RecipeUtil.getPreferredOreStack("gem" + ore);
                output.func_190920_e(Config.rotaryGrinderOreMultiplier);
                RotaryGrinderManager.INSTANCE.addRecipe(name, output);
                OreRefineryManager.INSTANCE.addOreRecipe(ore, name, "gem" + ore);
                continue;
            }
            if (name.startsWith("gem")) {
                ore = name.substring("gem".length());
                if (RecipeUtil.isOreBlacklisted(ore) || !RecipeUtil.oreExists("dust" + ore)) continue;
                RotaryGrinderManager.INSTANCE.addRecipe(name, RecipeUtil.getPreferredOreStack("dust" + ore));
                continue;
            }
            if (name.startsWith("ingot")) {
                ore = name.substring("ingot".length());
                if (RecipeUtil.isOreBlacklisted(ore) || !RecipeUtil.oreExists("dust" + ore)) continue;
                RotaryGrinderManager.INSTANCE.addRecipe(name, RecipeUtil.getPreferredOreStack("dust" + ore));
                continue;
            }
            if (name.startsWith("nugget")) {
                ore = name.substring("nugget".length());
                if (RecipeUtil.isOreBlacklisted(ore) || !RecipeUtil.oreExists("dustTiny" + ore)) continue;
                RotaryGrinderManager.INSTANCE.addRecipe(name, RecipeUtil.getPreferredOreStack("dustTiny" + ore), Config.rotaryGrinderProcessTime / 9);
                continue;
            }
            if (name.startsWith("block")) {
                ore = name.substring("block".length());
                if (RecipeUtil.isOreBlacklisted(ore)) continue;
                if (RecipeUtil.oreExists("dust" + ore)) {
                    output = RecipeUtil.getPreferredOreStack("dust" + ore);
                    output.func_190920_e(9);
                    RotaryGrinderManager.INSTANCE.addRecipe(name, output, Config.rotaryGrinderProcessTime * 9);
                    continue;
                }
                if (!RecipeUtil.oreExists("gem" + ore)) continue;
                output = RecipeUtil.getPreferredOreStack("gem" + ore);
                output.func_190920_e(9);
                RotaryGrinderManager.INSTANCE.addRecipe(name, output, Config.rotaryGrinderProcessTime * 9);
                continue;
            }
            if (name.startsWith("dustTiny")) {
                ore = name.substring("dustTiny".length());
                if (RecipeUtil.isOreBlacklisted(ore) || !RecipeUtil.oreExists("nugget" + ore)) continue;
                MagneticReassemblerManager.INSTANCE.addRecipe(name, RecipeUtil.getPreferredOreStack("nugget" + ore), Config.magneticReassemblerProcessTime / 9);
                continue;
            }
            if (!name.startsWith("dust") || RecipeUtil.isOreBlacklisted(ore = name.substring("dust".length()))) continue;
            if (RecipeUtil.oreExists("ingot" + ore)) {
                MagneticReassemblerManager.INSTANCE.addRecipe(name, RecipeUtil.getPreferredOreStack("ingot" + ore));
                continue;
            }
            if (!RecipeUtil.oreExists("gem" + ore)) continue;
            MagneticReassemblerManager.INSTANCE.addRecipe(name, RecipeUtil.getPreferredOreStack("gem" + ore));
        }
    }

    public static void initOreDict() {
        OreDictionary.registerOre((String)"blockFerramic", (Block)ModBlocks.ferramicBlock);
        OreDictionary.registerOre((String)"ingotFerramic", (Item)ModItems.ferramicIngot);
        OreDictionary.registerOre((String)"nuggetFerramic", (Item)ModItems.ferramicNugget);
        OreDictionary.registerOre((String)"gearFerramic", (Item)ModItems.ferramicGear);
        OreDictionary.registerOre((String)"dustCoal", (Item)ModItems.coalDust);
        OreDictionary.registerOre((String)"dustFerramic", (Item)ModItems.ferramicDust);
        OreDictionary.registerOre((String)"dustTinyFerramic", (Item)ModItems.ferramicDustTiny);
        OreDictionary.registerOre((String)"dustIron", (Item)ModItems.ironDust);
        OreDictionary.registerOre((String)"dustTinyIron", (Item)ModItems.ironDustTiny);
        OreDictionary.registerOre((String)"dustGold", (Item)ModItems.goldDust);
        OreDictionary.registerOre((String)"dustTinyGold", (Item)ModItems.goldDustTiny);
        OreDictionary.registerOre((String)"dustDiamond", (Item)ModItems.diamondDust);
        OreDictionary.registerOre((String)"dustEmerald", (Item)ModItems.emeraldDust);
        OreDictionary.registerOre((String)"dustQuartz", (Item)ModItems.quartzDust);
        OreDictionary.registerOre((String)"dustNetherQuartz", (Item)ModItems.quartzDust);
        OreDictionary.registerOre((String)"gemEnergion", (Item)ModItems.energionCrystalSeed);
        OreDictionary.registerOre((String)"dustEnergion", (Item)ModItems.energionDust);
        OreDictionary.registerOre((String)"leafZorra", (Item)ModItems.zorraLeaf);
        OreDictionary.registerOre((String)"ingotRawZorrasteel", (Item)ModItems.zorrasteelRaw);
        OreDictionary.registerOre((String)"ingotZorrasteel", (Item)ModItems.zorrasteelIngot);
        OreDictionary.registerOre((String)"blockZorrasteel", (Block)ModBlocks.zorrasteelBlock);
        OreDictionary.registerOre((String)"dustAsh", (Item)ModItems.ash);
        OreDictionary.registerOre((String)"dustWood", (Item)ModItems.sawdust);
        OreDictionary.registerOre((String)"foodFlour", (Item)ModItems.flour);
        OreDictionary.registerOre((String)"plateCarbon", (Item)ModItems.carbonPlate);
        OreDictionary.registerOre((String)"blockPlateCarbon", (Block)ModBlocks.carbonPlateBlock);
        OreDictionary.registerOre((String)"plankWood", (Block)ModBlocks.particleBoard);
        OreDictionary.registerOre((String)"plankWood", (Block)ModBlocks.particleBoardPlanks);
        OreDictionary.registerOre((String)"logWood", (Block)ModBlocks.zorraLog);
        OreDictionary.registerOre((String)"plankWood", (Block)ModBlocks.zorraPlanks);
        OreDictionary.registerOre((String)"treeLeaves", (Block)ModBlocks.zorraLeaves);
        OreDictionary.registerOre((String)"treeSapling", (Block)ModBlocks.zorraSapling);
        OreDictionary.registerOre((String)"cobblestoneCharred", (Block)ModBlocks.charredCobblestone);
        OreDictionary.registerOre((String)"stoneCharred", (Block)ModBlocks.charredStone);
    }

    public static void initSmelting() {
        GameRegistry.addSmelting((Block)ModBlocks.charredCobblestone, (ItemStack)new ItemStack(ModBlocks.charredStone), (float)0.1f);
        GameRegistry.addSmelting((Item)ModItems.flour, (ItemStack)new ItemStack(Items.field_151025_P), (float)0.35f);
        GameRegistry.addSmelting((Item)ModItems.meatGround, (ItemStack)new ItemStack(ModItems.meatPatty), (float)0.35f);
        GameRegistry.addSmelting((Item)ModItems.ferramicDust, (ItemStack)new ItemStack(ModItems.ferramicIngot), (float)0.1f);
        GameRegistry.addSmelting((Item)ModItems.ferramicDustTiny, (ItemStack)new ItemStack(ModItems.ferramicNugget), (float)0.0f);
        GameRegistry.addSmelting((Item)ModItems.ironDust, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.1f);
        GameRegistry.addSmelting((Item)ModItems.ironDustTiny, (ItemStack)new ItemStack(Items.field_191525_da), (float)0.0f);
        GameRegistry.addSmelting((Item)ModItems.goldDust, (ItemStack)new ItemStack(Items.field_151043_k), (float)0.1f);
        GameRegistry.addSmelting((Item)ModItems.goldDustTiny, (ItemStack)new ItemStack(Items.field_151074_bl), (float)0.0f);
    }
}

