/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lykrast.prodigytech.client.gui.GuiSolderer;
import lykrast.prodigytech.common.compat.jei.ProdigyTechJEI;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.SoldererManager;
import lykrast.prodigytech.common.util.Config;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class SoldererWrapper
implements IRecipeWrapper {
    private static final String BLOCKS = "container.prodigytech.solderer.gold.blocks";
    private static final String INGOTS = "container.prodigytech.solderer.gold.ingots";
    private static final String NUGGETS = "container.prodigytech.solderer.gold.nuggets";
    private ItemStack pattern;
    private ItemStack additive;
    private ItemStack output;
    private final IDrawableAnimated arrow;
    private final IDrawable goldGauge;
    private int goldAmount;
    private int goldScale;

    public SoldererWrapper(SoldererManager.SoldererRecipe recipe, IGuiHelper guiHelper) {
        this.pattern = recipe.getPattern();
        this.additive = recipe.getAdditive();
        this.output = recipe.getOutput();
        this.goldAmount = recipe.getGoldAmount();
        this.arrow = guiHelper.createAnimatedDrawable(ProdigyTechJEI.getDefaultProcessArrow(guiHelper), recipe.getTimeTicks(), IDrawableAnimated.StartDirection.LEFT, false);
        this.goldScale = this.goldAmount * 52 / Config.soldererMaxGold;
        this.goldGauge = guiHelper.createDrawable(GuiSolderer.GUI, 176, 35 + (52 - this.goldScale), 4, this.goldScale);
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<Object>> inputs = new ArrayList<List<Object>>();
        inputs.add(Collections.singletonList(this.pattern));
        NonNullList oreDust = OreDictionary.getOres((String)"dustTinyGold", (boolean)false);
        ArrayList<ItemStack> dust = new ArrayList<ItemStack>();
        for (ItemStack i : oreDust) {
            ItemStack n = i.func_77946_l();
            n.func_190920_e(this.goldAmount);
            dust.add(n);
        }
        inputs.add(dust);
        inputs.add(Collections.singletonList(this.additive));
        inputs.add(Collections.singletonList(new ItemStack(ModItems.circuitPlate)));
        ingredients.setInputLists(VanillaTypes.ITEM, inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.arrow.draw(minecraft, 60, 19);
        this.goldGauge.draw(minecraft, 30, 1 + (52 - this.goldScale));
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX >= 30 && mouseX <= 34) {
            int ingots;
            int tmp = this.goldAmount;
            ArrayList<String> list = new ArrayList<String>();
            int blocks = tmp / 81;
            if (blocks > 0) {
                list.add(I18n.func_135052_a((String)BLOCKS, (Object[])new Object[]{blocks}));
                tmp %= 81;
            }
            if ((ingots = tmp / 9) > 0) {
                list.add(I18n.func_135052_a((String)INGOTS, (Object[])new Object[]{ingots}));
                tmp %= 9;
            }
            if (tmp > 0) {
                list.add(I18n.func_135052_a((String)NUGGETS, (Object[])new Object[]{tmp}));
            }
            return list;
        }
        return Collections.emptyList();
    }
}

