/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lykrast.prodigytech.common.compat.jei.ProdigyTechJEI;
import lykrast.prodigytech.common.recipe.SimpleRecipe;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class SimpleRecipeWrapper
implements IRecipeWrapper {
    private ItemStack out;
    private List<List<ItemStack>> in;
    private final IDrawableAnimated arrow;

    public SimpleRecipeWrapper(ItemStack input, ItemStack output, int ticks, IGuiHelper guiHelper) {
        this.in = Collections.singletonList(Collections.singletonList(input));
        this.out = output;
        this.arrow = guiHelper.createAnimatedDrawable(ProdigyTechJEI.getDefaultProcessArrow(guiHelper), ticks, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public SimpleRecipeWrapper(SimpleRecipe recipe, IGuiHelper guiHelper) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        if (recipe.isOreRecipe()) {
            NonNullList items = OreDictionary.getOres((String)recipe.getOreInput(), (boolean)false);
            inputs.addAll((Collection<ItemStack>)items);
        } else {
            inputs.add(recipe.getInput());
        }
        this.in = Collections.singletonList(inputs);
        this.out = recipe.getOutput();
        this.arrow = guiHelper.createAnimatedDrawable(ProdigyTechJEI.getDefaultProcessArrow(guiHelper), recipe.getTimeTicks(), IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.in);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.out);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.arrow.draw(minecraft, 24, 5);
    }
}

