/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.jei;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lykrast.prodigytech.common.compat.jei.ProdigyTechJEI;
import lykrast.prodigytech.common.recipe.SimpleRecipeSecondaryOutput;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class SimpleRecipeSecondaryOutputWrapper
implements IRecipeWrapper {
    private List<List<ItemStack>> in;
    private List<ItemStack> out;
    private final IDrawableAnimated arrow;
    private int chance;

    public SimpleRecipeSecondaryOutputWrapper(SimpleRecipeSecondaryOutput recipe, IGuiHelper guiHelper) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        if (recipe.isOreRecipe()) {
            NonNullList items = OreDictionary.getOres((String)recipe.getOreInput(), (boolean)false);
            inputs.addAll((Collection<ItemStack>)items);
        } else {
            inputs.add(recipe.getInput());
        }
        this.in = Collections.singletonList(inputs);
        this.out = ImmutableList.of((Object)recipe.getOutput(), (Object)recipe.getSecondaryOutput());
        this.chance = recipe.hasSecondaryOutput() ? (int)(recipe.getSecondaryChance() * 100.0f) : 100;
        this.arrow = guiHelper.createAnimatedDrawable(ProdigyTechJEI.getDefaultProcessArrow(guiHelper), recipe.getTimeTicks(), IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.in);
        ingredients.setOutputs(VanillaTypes.ITEM, this.out);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.arrow.draw(minecraft, 24, 5);
        if (this.chance < 100) {
            String chanceString = this.chance < 1 ? "< 1%" : String.format("%d%%", this.chance);
            int width = minecraft.field_71466_p.func_78256_a(chanceString);
            minecraft.field_71466_p.func_78276_b(chanceString, 95 - width / 2, 28, Color.gray.getRGB());
        }
    }
}

