/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.jei;

import java.util.ArrayList;
import java.util.List;
import lykrast.prodigytech.common.compat.jei.ProdigyCategory;
import lykrast.prodigytech.common.compat.jei.ProdigyTechJEI;
import lykrast.prodigytech.common.compat.jei.SimpleRecipeWrapper;
import lykrast.prodigytech.common.tileentity.TileFuelProcessor;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;

public class FuelProcessorCategory
extends ProdigyCategory<SimpleRecipeWrapper> {
    public static final String UID = "ptfuelprocessor";

    public FuelProcessorCategory(IGuiHelper guiHelper) {
        super(guiHelper, (IDrawable)guiHelper.createDrawable(ProdigyTechJEI.GUI, 0, 36, 82, 26), UID);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SimpleRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 4);
        guiItemStacks.init(1, false, 60, 4);
        guiItemStacks.set(ingredients);
    }

    public static void registerRecipes(IModRegistry registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        ArrayList list = new ArrayList();
        List fuels = registry.getIngredientRegistry().getFuels();
        fuels.stream().forEach(fuel -> {
            if (TileFuelProcessor.isValidInput(fuel)) {
                list.add(FuelProcessorCategory.wrap(fuel, guiHelper));
            }
        });
        registry.addRecipes(list, UID);
    }

    private static SimpleRecipeWrapper wrap(ItemStack fuel, IGuiHelper guiHelper) {
        return new SimpleRecipeWrapper(fuel.func_77946_l(), new ItemStack(TileFuelProcessor.getResultingPellet(fuel), TileFuelProcessor.getPelletsAmount(fuel)), TileFuelProcessor.getProcessTime(fuel), guiHelper);
    }
}

